/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.file;

import java.io.File;
import java.util.ArrayList;
import net.sf.sfac.file.InvalidPathException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FilePathUtils {
    private static Log log = LogFactory.getLog(FilePathUtils.class);
    private boolean ignoreCase;
    private String appBaseDrive;
    private String appBasePath;
    private char separatorChar;

    public FilePathUtils(File baseDir) {
        this.ignoreCase = this.checkFileSystemIgnoreCase();
        this.separatorChar = File.separatorChar;
        try {
            this.appBasePath = baseDir.getCanonicalPath();
            this.appBaseDrive = FilePathUtils.getDrive(this.appBasePath);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("The base directory '" + baseDir + "' is invalid !", e);
        }
    }

    public FilePathUtils(String basePath, boolean ignoreCaseInPaths) {
        this.ignoreCase = ignoreCaseInPaths;
        this.separatorChar = (char)(basePath.indexOf(92) >= 0 ? 92 : 47);
        try {
            this.appBaseDrive = FilePathUtils.getDrive(basePath);
            this.appBasePath = this.canonicalize(basePath);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("The base directory '" + basePath + "' is invalid !", e);
        }
    }

    public char getSparatorChar() {
        return this.separatorChar;
    }

    private boolean checkFileSystemIgnoreCase() {
        boolean fileSystemIgnoresCase = true;
        boolean checked = false;
        try {
            String tempDir = System.getProperty("java.io.tmpdir");
            File fil = new File(tempDir);
            String filePath = fil.getAbsolutePath();
            String uppercaseFilePath = filePath.toUpperCase();
            String lowercaseFilePath = filePath.toLowerCase();
            if (!lowercaseFilePath.equals(uppercaseFilePath)) {
                File uppercaseFile = new File(uppercaseFilePath);
                File lowercaseFile = new File(lowercaseFilePath);
                fileSystemIgnoresCase = uppercaseFile.exists() && lowercaseFile.exists();
                checked = true;
            }
            if (!checked) {
                log.warn((Object)"Cannot check if file system is case-senstive (assume it is not)");
            }
        }
        catch (Exception e) {
            log.error((Object)"Cannot check if file system is case-senstive (assume it is not)", (Throwable)e);
        }
        return fileSystemIgnoresCase;
    }

    public String getBasePath() {
        return this.appBasePath;
    }

    public String getAbsoluteFilePath(String filePath) throws InvalidPathException {
        if (filePath == null) {
            return null;
        }
        if (FilePathUtils.isWhite(filePath) || FilePathUtils.isThisPath(filePath)) {
            return this.appBasePath;
        }
        if (!FilePathUtils.isAbsolute(filePath)) {
            filePath = FilePathUtils.concatPaths(this.appBasePath, filePath);
        }
        if (this.appBaseDrive != null && FilePathUtils.getDrive(filePath) == null) {
            filePath = this.appBaseDrive + filePath;
        }
        return this.canonicalize(filePath);
    }

    private String canonicalize(String originalPath) throws InvalidPathException {
        int nbrItems;
        if (originalPath == null) {
            return null;
        }
        String absolutePath = originalPath;
        absolutePath = this.separatorChar == '/' ? absolutePath.replace('\\', '/') : absolutePath.replace('/', '\\');
        ArrayList<String> items = new ArrayList<String>();
        if (FilePathUtils.startsWithSeparator(absolutePath = absolutePath.trim())) {
            absolutePath = absolutePath.substring(1);
        }
        if (FilePathUtils.endsWithSeparator(absolutePath)) {
            absolutePath = absolutePath.substring(0, absolutePath.length() - 1);
        }
        int firstPathItem = this.appBaseDrive == null ? 0 : 1;
        int lastIndex = 0;
        int slashIndex = 0;
        while (slashIndex >= 0) {
            slashIndex = absolutePath.indexOf(this.separatorChar, lastIndex);
            String pathItem = slashIndex >= 0 ? absolutePath.substring(lastIndex, slashIndex) : absolutePath.substring(lastIndex);
            if (!pathItem.equals(".")) {
                if (pathItem.equals("..")) {
                    nbrItems = items.size();
                    if (nbrItems <= firstPathItem) {
                        throw new InvalidPathException("Too many '..' in path '" + originalPath + "'");
                    }
                    items.remove(nbrItems - 1);
                } else {
                    if (items.size() >= firstPathItem) {
                        this.checkPathItem(originalPath, pathItem);
                    }
                    items.add(pathItem);
                }
            }
            lastIndex = slashIndex + 1;
        }
        StringBuffer sb = new StringBuffer();
        if (this.appBaseDrive == null) {
            sb.append(this.separatorChar);
        }
        nbrItems = items.size();
        for (int i = 0; i < nbrItems; ++i) {
            if (i > 0) {
                sb.append(this.separatorChar);
            }
            sb.append((String)items.get(i));
        }
        if (this.appBaseDrive != null && nbrItems == 1) {
            sb.append(this.separatorChar);
        }
        return sb.toString();
    }

    private void checkPathItem(String path, String str) throws InvalidPathException {
        int len = str.length();
        if (len == 0) {
            throw new InvalidPathException("Empty path item in path '" + path + "'");
        }
        for (int i = 0; i < len; ++i) {
            switch (str.charAt(i)) {
                case '\"': 
                case '*': 
                case '/': 
                case ':': 
                case '<': 
                case '>': 
                case '?': 
                case '\\': 
                case '|': {
                    throw new InvalidPathException("Illegal character '" + str.charAt(i) + "' in path '" + path + "'");
                }
            }
        }
    }

    public String getRelativeFilePath(String filePath) throws InvalidPathException {
        String relativePath;
        if (filePath == null) {
            return null;
        }
        if (FilePathUtils.isWhite(filePath) || FilePathUtils.isThisPath(filePath)) {
            return ".";
        }
        if (!FilePathUtils.isAbsolute(filePath)) {
            return filePath;
        }
        String drive = FilePathUtils.getDrive(filePath);
        if (this.appBaseDrive != null && drive == null) {
            filePath = this.appBaseDrive + filePath;
        }
        filePath = this.canonicalize(filePath);
        int fileLen = filePath.length();
        int baseLen = this.appBasePath.length();
        if (this.startsWithCheckCase(filePath, this.appBasePath) && (fileLen == baseLen || FilePathUtils.isSeparatorChar(filePath.charAt(baseLen)))) {
            relativePath = filePath.substring(this.appBasePath.length());
        } else if (drive == null || this.equalsCheckCase(drive, this.appBaseDrive)) {
            char ch;
            int i;
            int divergenceIndex = 0;
            int len = fileLen < baseLen ? fileLen : baseLen;
            for (i = 0; i < len && this.equalsCheckCase(ch = filePath.charAt(i), this.appBasePath.charAt(i)); ++i) {
                if (!FilePathUtils.isSeparatorChar(ch)) continue;
                divergenceIndex = i + 1;
            }
            if (i == fileLen && i < baseLen && FilePathUtils.isSeparatorChar(this.appBasePath.charAt(len))) {
                divergenceIndex = len + 1;
            }
            StringBuffer sb = new StringBuffer(".." + this.separatorChar);
            for (i = divergenceIndex; i < baseLen; ++i) {
                if (!FilePathUtils.isSeparatorChar(this.appBasePath.charAt(i))) continue;
                sb.append(".." + this.separatorChar);
            }
            if (divergenceIndex < fileLen) {
                sb.append(filePath.substring(divergenceIndex));
            }
            relativePath = sb.toString();
        } else {
            return filePath;
        }
        if (FilePathUtils.startsWithSeparator(relativePath)) {
            relativePath = relativePath.substring(1);
        }
        if (FilePathUtils.endsWithSeparator(relativePath)) {
            relativePath = relativePath.substring(0, relativePath.length() - 1);
        }
        if (relativePath.length() == 0) {
            relativePath = ".";
        }
        return relativePath;
    }

    private static boolean isSeparatorChar(char ch) {
        return ch == '/' || ch == '\\';
    }

    private static boolean startsWithSeparator(String str) {
        return str.startsWith("/") || str.startsWith("\\");
    }

    private static boolean endsWithSeparator(String str) {
        return str.endsWith("/") || str.endsWith("\\");
    }

    private static boolean isThisPath(String str) {
        return "./".equals(str) || ".\\".equals(str) || ".".equals(str);
    }

    public static boolean isAbsolute(String filePath) {
        if (filePath == null) {
            return false;
        }
        if (filePath.indexOf(58) > 0) {
            return true;
        }
        return FilePathUtils.startsWithSeparator(filePath);
    }

    public static String getDrive(String filePath) {
        if (filePath == null) {
            return null;
        }
        int colonIndex = filePath.indexOf(58);
        return colonIndex > 0 ? filePath.substring(0, colonIndex + 1) : null;
    }

    public static String concatPaths(String firstPath, String secondPath) {
        if (FilePathUtils.isWhite(secondPath)) {
            return firstPath;
        }
        if (FilePathUtils.isAbsolute(secondPath)) {
            return secondPath;
        }
        if (FilePathUtils.isWhite(firstPath) || FilePathUtils.isThisPath(firstPath)) {
            return secondPath;
        }
        if (FilePathUtils.endsWithSeparator(firstPath)) {
            return firstPath + secondPath;
        }
        return firstPath + File.separator + secondPath;
    }

    private boolean startsWithCheckCase(String str, String startStr) {
        if (startStr == null) {
            return true;
        }
        if (str == null) {
            return false;
        }
        int startLen = startStr.length();
        if (str.length() >= startLen) {
            return str.regionMatches(this.ignoreCase, 0, startStr, 0, startLen);
        }
        return false;
    }

    private boolean equalsCheckCase(char ch1, char ch2) {
        if (this.ignoreCase) {
            return Character.toLowerCase(ch1) == Character.toLowerCase(ch2);
        }
        return ch1 == ch2;
    }

    private boolean equalsCheckCase(String str1, String str2) {
        if (str1 == null) {
            return str2 == null;
        }
        if (this.ignoreCase) {
            return str1.equalsIgnoreCase(str2);
        }
        return str1.equals(str2);
    }

    private static boolean isWhite(String str) {
        if (str == null) {
            return true;
        }
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (str.charAt(i) <= ' ') continue;
            return false;
        }
        return true;
    }

    public static String getExtension(String fileName) {
        if (fileName == null) {
            return null;
        }
        int lastDotIndex = fileName.lastIndexOf(46);
        if (lastDotIndex < 0) {
            return null;
        }
        if (fileName.lastIndexOf(47) > lastDotIndex) {
            return null;
        }
        if (fileName.lastIndexOf(92) > lastDotIndex) {
            return null;
        }
        return fileName.substring(lastDotIndex + 1);
    }

    public static String getDirectoryPath(String filePath) {
        int lastBackSlashIndex;
        if (filePath == null) {
            return null;
        }
        int lastSlashIndex = filePath.lastIndexOf(47);
        int index = Math.max(lastSlashIndex, lastBackSlashIndex = filePath.lastIndexOf(92));
        if (index >= 0) {
            return filePath.substring(0, index);
        }
        return null;
    }

    public static String getFileName(String filePath) {
        int lastBackSlashIndex;
        if (filePath == null) {
            return null;
        }
        int lastSlashIndex = filePath.lastIndexOf(47);
        int index = Math.max(lastSlashIndex, lastBackSlashIndex = filePath.lastIndexOf(92));
        if (index >= 0) {
            return filePath.substring(index + 1);
        }
        return filePath;
    }
}

