/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.editor;

import java.util.ArrayList;
import java.util.List;
import net.sf.sfac.editor.ValidationMessage;
import net.sf.sfac.editor.ValidationMessageImpl;
import net.sf.sfac.editor.ValidationReport;
import net.sf.sfac.lang.MultiLingualTextImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationReportImpl
implements ValidationReport {
    private List<ValidationMessage> messages;

    @Override
    public ValidationMessage.Level getGlobalValidationLevel() {
        ValidationMessage.Level lev = ValidationMessage.Level.OK;
        if (this.messages != null) {
            for (ValidationMessage msg : this.messages) {
                if (!msg.getLevel().greaterThan(lev)) continue;
                lev = msg.getLevel();
            }
        }
        return lev;
    }

    @Override
    public void addValidationMessage(ValidationMessage validationMsg) {
        if (this.messages == null) {
            this.messages = new ArrayList<ValidationMessage>();
        }
        this.messages.add(validationMsg);
    }

    @Override
    public void addMandatoryError(String fieldPath, String fieldName) {
        MultiLingualTextImpl translatedName = new MultiLingualTextImpl(fieldName, new Object[0]);
        this.addError(fieldPath, "MANDATORY_FIELD", translatedName);
    }

    @Override
    public void addError(String fieldPath, String key, Object ... params) {
        String path = fieldPath;
        this.addValidationMessage(new ValidationMessageImpl(ValidationMessage.Level.ERROR, path, key, params));
    }

    @Override
    public void addWarning(String fieldPath, String key, Object ... params) {
        String path = fieldPath;
        this.addValidationMessage(new ValidationMessageImpl(ValidationMessage.Level.WARNING, path, key, params));
    }

    @Override
    public void addInfo(String fieldPath, String key, Object ... params) {
        String path = fieldPath;
        this.addValidationMessage(new ValidationMessageImpl(ValidationMessage.Level.INFO, path, key, params));
    }

    @Override
    public List<ValidationMessage> getValidationMessages() {
        return this.messages;
    }

    @Override
    public ValidationReport getContextReport(String fieldPath) {
        return this;
    }
}

