/*-------------------------------------------------------------------------
 Copyright 2009 Olivier Berlanger

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 -------------------------------------------------------------------------*/
package net.sf.sfac.string;


/**
 * Char iterator: Iterate on the characted of any kind of character source. <br>
 * The iterator can normalize the returned characters. The method returning normalized and non-normalized chars can be mixed in
 * a iteration.
 * 
 * @author Olivier Berlanger
 */
public interface CharIterator {


    /**
     * Reset the internal pointer of this iterator to the first char.
     */
    public void reset();


    /**
     * Get the next char of this iterator. <br>
     * The returned char are not normalized. When no more characters are available, an zero char ('\0') is returned.
     * 
     * @return the next char of this iterator or '\0' if no more characters are availbale.
     */
    public char nextChar();


    /**
     * Get the next char of this iterator. <br>
     * The chars returned by this method are normalized as following:
     * <ul>
     * <li>Accentued chars replaced by the corresponding non-accentued char.
     * <li>All lowercase.
     * <li>Leading white space(s) removed.
     * <li>All non-letter or digit chars replaced by space.
     * <li>Any suite of white chars replaced by a single space.
     * </ul>
     * When no more characters are available, an zero char ('\0') is returned.
     * 
     * @return the next char of this iterator or '\0' if no more characters are availbale.
     */
    public char nextNormalizedChar();


    /**
     * Get the content of this char iterator as a normalized string. <br>
     * The result will be:
     * <ul>
     * <li>All lowercase.
     * <li>Trimmed.
     * <li>All non-letter or non-digit chars replaced by space.
     * <li>Any suite of white chars replaced by a single space.
     * </ul>
     * 
     * @return The content of this char iterator as a normalized string.
     */
    public String getNormalizedString();


}
