/*-------------------------------------------------------------------------
 Copyright 2009 Olivier Berlanger

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 -------------------------------------------------------------------------*/
package net.sf.sfac.setting;


/**
 * Interface used to manage and identify a data type inside the Settings implementation. <br>
 * This interface provides two method used to convert between string and the target data type. You will need to provide an
 * instance of this helper for each new type supported by the settings implementation.
 * 
 * @author Olivier Berlanger
 */
public abstract class TypeHelper<T> {


    /**
     * Convert a string to an object of the target data type.
     * 
     * @param str
     *            The string to convert.
     * @return An object of the target data type.
     * @exception Exception
     *                If the conversion cannot be performed.
     */
    public abstract T stringToObject(String str) throws Exception;


    /**
     * Convert an object of the target data type to a string.
     * 
     * @param obj
     *            An object of the target data type to convert.
     * @return The converted string.
     */

    public String objectToString(T obj) {
        return (obj == null) ? null : obj.toString();
    }

}
