/*-------------------------------------------------------------------------
 Copyright 2009 Olivier Berlanger

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 -------------------------------------------------------------------------*/
package net.sf.sfac.setting;


/**
 * Interface provided by objects using profiles. <br>
 * The profile client must:
 * <ul>
 * <li>Provide a global Settings object that will contain the profiles (as a SubSettingList).
 * <li>Provide a currentSubSettings object (which is usually a SubSettingsProxy of the global settings) that contains the values
 * that are "profiled".
 * </ul>
 * The currentSubSettings must be used by all the objects wanting to see the "profile" data. Then you can use a
 * ProfileController in your application to manage profiles. The profiles are copies of the currentSubSettings that can be saved
 * and restored.
 * <p>
 * To create and 'save' a profile, the controller:
 *<ul>
 * <li>calls getCurrentSubSettings() to have the settings to save. At this stage all objects using this settings must have
 * correctly stored the value they want to persist in this settings.
 * <li>Make a copy of is and 'store' it in a SubSettingList inside the global settings.
 * </ul>
 * </p>
 * <p>
 * To restore a profile, the controller:
 *<ul>
 * <li>calls updateCurrentSubSettings(Settings profile) to update the current settings with values of the restored profile. It's
 * up to the client to correctly update the current sub-settings. this is done usually doing (assuming that the current
 * sub-settings is an instance of SubSettingProxy):
 * 
 * <pre>
 *     currentSubSettings.clear()
 *     currentSubSettings.copyValues(profile)
 * </pre>
 * 
 * </ul>
 * </p>
 * 
 * @author Olivier Berlanger
 */
public interface ProfilesClient {


    public Settings getGlobalSettings();


    public Settings getCurrentSubSettings();


    public void updateCurrentSubSettings(Settings profile);


}
