/*-------------------------------------------------------------------------
 Copyright 2009 Olivier Berlanger

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 -------------------------------------------------------------------------*/
package net.sf.sfac.editor;


/**
 * An interface to be implemented by objects wanting to provide validation.
 * 
 * @author Olivier Berlanger
 */
public interface Validable {


    /**
     * Validate creation of the object. <br>
     * Any problem (info/warning/error) is added in the given ValidationReport. If this object contains Validable sub-objects,
     * it can forward the validation call to them. In this case, the path must be correctly updated.
     * 
     * @param report
     *            the ValidationReport where to add any info/warning/error raised by the validation.
     */
    public void validateCreation(ValidationReport report);


    /**
     * Validate modification of the object. <br>
     * Any problem (info/warning/error) is added in the given ValidationReport. If this object contains Validablme sub-objects,
     * it can forward the validation call to them. In this case, the path must be correctly updated.
     * 
     * @param report
     *            the ValidationReport where to add any info/warning/error raised by the validation.
     */
    public void validateModification(ValidationReport report);


    /**
     * Validate deletion of the object. <br>
     * This method is called before the object is actually deleted (so before the links it may have to other objects are cut). <br>
     * Any problem (info/warning/error) is added in the given ValidationReport. If this object contains <code>Validable</code>
     * sub-objects, it can forward the validation call to them. In this case, the path must be correctly updated.
     * 
     * @param report
     *            the ValidationReport where to add any info/warning/error raised by the validation.
     */
    public void validateDelete(ValidationReport report);


}
