/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.launcher;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationLauncher {
    public static final String BASE_DIR_KEY = "base.dir";
    public static final String EXTRA_PARAMS_KEY = "extra.params";
    public static final String LAUNCHER_PROPERTIES_KEY = "launcher.properties";
    public static final String LIB_PATH_KEY = "lib.path";
    public static final String MAIN_CLASS_KEY = "main.class";
    public static final String RECURSIVE_LIB_SEARCH_KEY = "recursive.lib.search";
    public static final String SHOW_HELP_KEY = "show.help";
    public static final String VERBOSE_KEY = "verbose";
    private Properties launcherProperties;

    public ApplicationLauncher(Properties cmdLineProperties) {
        this.launcherProperties = cmdLineProperties;
        boolean verbose = "true".equals(this.launcherProperties.get(VERBOSE_KEY));
        URL resourceProperties = this.getClass().getResource("/sfac-laucher.properties");
        if (resourceProperties != null) {
            try {
                System.out.println("Load configuration properties from resource: " + resourceProperties);
                InputStream is = resourceProperties.openStream();
                this.launcherProperties.load(is);
                is.close();
                verbose = "true".equals(this.launcherProperties.get(VERBOSE_KEY));
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to read resource properties from: " + resourceProperties.toExternalForm(), e);
            }
        } else if (verbose) {
            System.out.println("No resource named '/sfac-laucher.properties' found");
        }
        File baseDir = this.getBaseDir();
        String configFilepath = this.launcherProperties.getProperty(LAUNCHER_PROPERTIES_KEY, "sfac-launcher.properties");
        File configFile = new File(baseDir, configFilepath);
        if (configFile.exists()) {
            try {
                System.out.println("Load configuration properties from file: " + resourceProperties);
                BufferedReader reader = new BufferedReader(new FileReader(configFile));
                this.launcherProperties.load(reader);
                reader.close();
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to read file properties from: " + configFile.getAbsolutePath(), e);
            }
        } else if (verbose) {
            System.out.println("No config file named '" + configFile + "' found");
        }
    }

    public File getBaseDir() {
        File baseDir;
        try {
            boolean verbose = "true".equals(this.launcherProperties.get(VERBOSE_KEY));
            String basePath = (String)this.launcherProperties.get(BASE_DIR_KEY);
            if (basePath != null) {
                baseDir = new File(basePath).getCanonicalFile();
                if (verbose) {
                    System.out.println("Base dir specified = " + baseDir);
                }
            } else {
                URL baseUrl = this.getClass().getResource(this.getClass().getSimpleName() + ".class");
                basePath = baseUrl.getFile();
                int exclamationIndex = basePath.indexOf(33);
                if (exclamationIndex > 0) {
                    File jarFile = new File(new URI(basePath.substring(0, exclamationIndex)));
                    baseDir = jarFile.getParentFile().getCanonicalFile();
                    if (verbose) {
                        System.out.println("Base dir (deduced from jar file) = " + baseDir);
                    }
                } else {
                    baseDir = new File("").getCanonicalFile();
                    if (verbose) {
                        System.out.println("Use default base dir = " + baseDir);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to evaluate base directory", e);
        }
        return baseDir;
    }

    public void launchApplication() throws Exception {
        Object[] args;
        boolean showHelp;
        boolean verbose = "true".equals(this.launcherProperties.get(VERBOSE_KEY));
        if (verbose) {
            System.out.println("Consolidated launcher properties:");
            for (Object key : this.launcherProperties.keySet()) {
                System.out.println("   * " + key + " = " + this.launcherProperties.get(key));
            }
        }
        if (showHelp = "true".equals(this.launcherProperties.get(SHOW_HELP_KEY))) {
            ApplicationLauncher.displayUsage();
            System.exit(0);
        }
        URLClassLoader classLoader = this.configureClassLoader(verbose);
        String className = this.launcherProperties.getProperty(MAIN_CLASS_KEY, null);
        if (className == null) {
            throw new IllegalArgumentException("Main class name is mandatory!\nPlease use --c command line switch or define main.class property");
        }
        String argList = this.launcherProperties.getProperty(EXTRA_PARAMS_KEY, null);
        Object[] objectArray = args = argList == null ? new String[]{} : argList.split(" ");
        if (verbose) {
            System.out.println("Launch class " + className);
            System.out.println("    args = " + Arrays.toString(args));
        }
        Class<?> clazz = classLoader.loadClass(className);
        Method main = clazz.getDeclaredMethod("main", String[].class);
        main.invoke(null, new Object[]{args});
    }

    private URLClassLoader configureClassLoader(boolean verbose) {
        boolean recursive = "true".equals(this.launcherProperties.get(RECURSIVE_LIB_SEARCH_KEY));
        String pathList = this.launcherProperties.getProperty(LIB_PATH_KEY, ".");
        String[] paths = pathList.split(";");
        File baseDir = this.getBaseDir();
        ArrayList<URL> jarUrls = new ArrayList<URL>();
        for (String path : paths) {
            try {
                File libDir = new File(baseDir, path.trim()).getCanonicalFile();
                this.addJars(libDir, jarUrls, verbose, recursive);
            }
            catch (IOException ioe) {
                System.err.println("Error: unable to get jars from directory: '" + path + "'");
                ioe.printStackTrace();
            }
        }
        URL[] urls = jarUrls.toArray(new URL[jarUrls.size()]);
        URLClassLoader classLoader = new URLClassLoader(urls, this.getClass().getClassLoader());
        Thread.currentThread().setContextClassLoader(classLoader);
        if (verbose) {
            System.out.println("URL class loader created: " + classLoader);
        }
        return classLoader;
    }

    private void addJars(File libDir, List<URL> jarUrls, boolean verbose, boolean recursive) {
        if (verbose) {
            System.out.println("Add libraries from: " + libDir);
        }
        if (libDir.exists()) {
            for (File fil : libDir.listFiles()) {
                if (fil.isDirectory()) {
                    if (!recursive) continue;
                    this.addJars(fil, jarUrls, verbose, recursive);
                    continue;
                }
                if (!fil.getName().endsWith(".jar")) continue;
                try {
                    if (verbose) {
                        System.out.println("   * " + fil.getCanonicalPath());
                    }
                    URL jarUrl = fil.toURI().toURL();
                    jarUrls.add(jarUrl);
                }
                catch (Exception e) {
                    System.err.println("Unable to build URL for file: " + fil);
                    e.printStackTrace();
                }
            }
        } else if (verbose) {
            System.out.println("  -> directory not found !");
        }
    }

    public static void main(String[] args) {
        Properties cmdLineProps = new Properties();
        boolean commandLineError = ApplicationLauncher.parseCommandLine(args, cmdLineProps);
        if (commandLineError) {
            ApplicationLauncher.displayUsage();
        } else {
            try {
                ApplicationLauncher launcher = new ApplicationLauncher(cmdLineProps);
                launcher.launchApplication();
            }
            catch (Exception e) {
                System.err.println("Failed to start application '" + cmdLineProps.get(MAIN_CLASS_KEY) + "'");
                e.printStackTrace();
                ApplicationLauncher.displayUsage();
            }
        }
    }

    private static boolean parseCommandLine(String[] args, Properties cmdLineProps) {
        boolean commandLineError = false;
        ArrayList<String> extraArgs = new ArrayList<String>();
        int argLen = args == null ? 0 : args.length;
        for (int i = 0; i < argLen && !commandLineError; ++i) {
            if (args[i].equals("--d")) {
                if (i == argLen - 1) {
                    System.err.println("--d must be followed by lib directory");
                    commandLineError = true;
                    continue;
                }
                cmdLineProps.put(LIB_PATH_KEY, args[++i]);
                continue;
            }
            if (args[i].equals("--b")) {
                if (i == argLen - 1) {
                    System.err.println("--b must be followed by base directory");
                    commandLineError = true;
                    continue;
                }
                cmdLineProps.put(BASE_DIR_KEY, args[++i]);
                continue;
            }
            if (args[i].equals("--e")) {
                if (i == argLen - 1) {
                    System.err.println("--e must be followed by config. file path");
                    commandLineError = true;
                    continue;
                }
                cmdLineProps.put(LAUNCHER_PROPERTIES_KEY, args[++i]);
                continue;
            }
            if (args[i].equals("--c")) {
                if (i == argLen - 1) {
                    System.err.println("--c must be followed by main class name");
                    commandLineError = true;
                    continue;
                }
                cmdLineProps.put(MAIN_CLASS_KEY, args[++i]);
                continue;
            }
            if (args[i].equals("--v")) {
                cmdLineProps.put(VERBOSE_KEY, "true");
                continue;
            }
            if (args[i].equals("--r")) {
                cmdLineProps.put(RECURSIVE_LIB_SEARCH_KEY, "true");
                continue;
            }
            if (args[i].equals("--h") || args[i].equals("--?")) {
                cmdLineProps.put(SHOW_HELP_KEY, "true");
                continue;
            }
            extraArgs.add(args[i]);
        }
        if (extraArgs.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (String arg : extraArgs) {
                if (sb.length() > 0) {
                    sb.append(' ');
                }
                sb.append(arg);
            }
            cmdLineProps.put(EXTRA_PARAMS_KEY, sb.toString());
        }
        return commandLineError;
    }

    private static void displayUsage() {
        System.out.println("Usage:");
        System.out.println("   java [jvm args] -cp sfac-launcher-x.jar net.sf.sfac.launcher.ApplicationLauncher [--v] [--h] [--r] [--e configFile] [--d libPath] [--c className] [application args]");
        System.out.println(" or");
        System.out.println("   java [jvm args] -jar sfac-launcher-x.jar [--v] [--h] [--r] [--e configFile] [--d libPath] [--c className] [application args]");
        System.out.println("where:");
        System.out.println("   --v                 Verbose flag");
        System.out.println("   --h                 Display usage");
        System.out.println("   --e configFile      Path to execution configuration file (default = './sfac-launcher.properties')");
        System.out.println("   --b baseDir         Path of the base directory for resolving all relative paths.");
        System.out.println("                       default = the directory containing the sfac-launcher-xxx.jar.");
        System.out.println("   --d libPath         Path of the directory containing jars");
        System.out.println("                       This parameter can contain several directory names separated by semicolons.");
        System.out.println("                       default = the directory containing the sfac-launcher-xxx.jar.");
        System.out.println("   --r                 recursive search of jars into libPath sub-directories (default=false)");
        System.out.println("   --c className       Fully qualified name of the 'main' class of the application");
        System.out.println("   [application args]  Parameters passed to the main method of the application");
        System.out.println("");
    }
}

