/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.launcher;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import net.sf.sfac.launcher.SplashWindow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationLauncher {
    public static final String LAUNCHER_PROPERTIES_KEY = "launcher.properties";
    public static final String BASE_DIR_KEY = "base.dir";
    public static final String MAIN_CLASS_KEY = "main.class";
    public static final String EXTRA_PARAMS_KEY = "extra.params";
    public static final String LIB_PATH_KEY = "lib.path";
    public static final String SPLASH_IMG_KEY = "splash.img";
    public static final String VERBOSE_KEY = "verbose.dir";
    public static final String RECURSIVE_LIB_SEARCH_KEY = "recursive.lib.search";
    public static final String SHOW_HELP_KEY = "show.help";
    private Properties launcherProperties;

    public ApplicationLauncher(Properties cmdLineProperties) {
        this.launcherProperties = cmdLineProperties;
        URL resourceProperties = this.getClass().getResource("/sfac-laucher.properties");
        if (resourceProperties != null) {
            try {
                InputStream is = resourceProperties.openStream();
                this.launcherProperties.load(is);
                is.close();
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to read resource properties from: " + resourceProperties.toExternalForm(), e);
            }
        } else {
            System.out.println("No resource named '/sfac-laucher.properties' found");
        }
        File baseDir = this.getBaseDir();
        String configFilepath = this.launcherProperties.getProperty(LAUNCHER_PROPERTIES_KEY, "sfac-launcher.properties");
        File configFile = new File(baseDir, configFilepath);
        if (configFile.exists()) {
            try {
                BufferedReader reader = new BufferedReader(new FileReader(configFile));
                this.launcherProperties.load(reader);
                reader.close();
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to read file properties from: " + configFile.getAbsolutePath(), e);
            }
        } else {
            System.out.println("No file named '" + configFile + "' found");
        }
    }

    public File getBaseDir() {
        File baseDir;
        try {
            boolean verbose = "true".equals(this.launcherProperties.get(VERBOSE_KEY));
            String basePath = (String)this.launcherProperties.get(BASE_DIR_KEY);
            if (basePath != null) {
                baseDir = new File(basePath).getCanonicalFile();
                if (verbose) {
                    System.out.println("Base dir specified = " + baseDir);
                }
            } else {
                URL baseUrl = this.getClass().getResource(this.getClass().getSimpleName() + ".class");
                basePath = baseUrl.getFile();
                int exclamationIndex = basePath.indexOf(33);
                if (exclamationIndex > 0) {
                    File jarFile = new File(new URI(basePath.substring(0, exclamationIndex)));
                    baseDir = jarFile.getParentFile().getCanonicalFile();
                    if (verbose) {
                        System.out.println("Base dir (deduced from jar file) = " + baseDir);
                    }
                } else {
                    baseDir = new File("").getCanonicalFile();
                    if (verbose) {
                        System.out.println("Use default base dir = " + baseDir);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to evaluate base directory", e);
        }
        return baseDir;
    }

    public void launchApplication() throws Exception {
        Object[] args;
        boolean verbose = "true".equals(this.launcherProperties.get(VERBOSE_KEY));
        String splashImageName = this.launcherProperties.getProperty(SPLASH_IMG_KEY);
        SplashWindow.showSplashWindow(splashImageName, verbose);
        URLClassLoader classLoader = this.configureClassLoader(verbose);
        String className = this.launcherProperties.getProperty(MAIN_CLASS_KEY, null);
        if (className == null) {
            throw new IllegalArgumentException("Main class name is mandatory!\nPlease use -c command line switch or define main.class property");
        }
        String argList = this.launcherProperties.getProperty(EXTRA_PARAMS_KEY, null);
        Object[] objectArray = args = argList == null ? new String[]{} : argList.split(" ");
        if (verbose) {
            System.out.println("Launch class " + className);
            System.out.println("    args = " + Arrays.toString(args));
        }
        Class<?> clazz = classLoader.loadClass(className);
        Method main = clazz.getDeclaredMethod("main", String[].class);
        main.invoke(null, new Object[]{args});
        SplashWindow.hideSplashWindow();
    }

    private URLClassLoader configureClassLoader(boolean verbose) {
        boolean recursive = "true".equals(this.launcherProperties.get(RECURSIVE_LIB_SEARCH_KEY));
        String pathList = this.launcherProperties.getProperty(LIB_PATH_KEY, "lib");
        String[] paths = pathList.split(";");
        File baseDir = this.getBaseDir();
        ArrayList<URL> jarUrls = new ArrayList<URL>();
        for (String path : paths) {
            File libDir = new File(baseDir, path.trim());
            this.addJars(libDir, jarUrls, verbose, recursive);
        }
        URL[] urls = jarUrls.toArray(new URL[jarUrls.size()]);
        URLClassLoader classLoader = new URLClassLoader(urls, this.getClass().getClassLoader());
        Thread.currentThread().setContextClassLoader(classLoader);
        if (verbose) {
            System.out.println("URL class loader created: " + classLoader);
        }
        return classLoader;
    }

    private void addJars(File libDir, List<URL> jarUrls, boolean verbose, boolean recursive) {
        if (verbose) {
            System.out.println("Add libraries from: " + libDir);
        }
        if (libDir.exists()) {
            for (File fil : libDir.listFiles()) {
                if (fil.isDirectory()) {
                    if (!recursive) continue;
                    this.addJars(fil, jarUrls, verbose, recursive);
                    continue;
                }
                if (!fil.getName().endsWith(".jar")) continue;
                try {
                    if (verbose) {
                        System.out.println("   * " + fil);
                    }
                    jarUrls.add(fil.toURI().toURL());
                }
                catch (Exception e) {
                    System.err.println("Unable to build URL for file: " + fil);
                    e.printStackTrace();
                }
            }
        } else if (verbose) {
            System.out.println("  -> directory not found !");
        }
    }

    public static void main(String[] args) {
        Properties cmdLineProps = new Properties();
        boolean commandLineError = ApplicationLauncher.parseCommandLine(args, cmdLineProps);
        if (commandLineError) {
            ApplicationLauncher.displayUsage();
        } else {
            try {
                ApplicationLauncher launcher = new ApplicationLauncher(cmdLineProps);
                launcher.launchApplication();
            }
            catch (Exception e) {
                System.err.println("Failed to start application: " + cmdLineProps.get(MAIN_CLASS_KEY));
                e.printStackTrace();
            }
        }
    }

    private static boolean parseCommandLine(String[] args, Properties cmdLineProps) {
        int argLen;
        boolean commandLineError = false;
        int n = argLen = args == null ? 0 : args.length;
        if (argLen == 0) {
            System.out.println("No command line parameter defined");
        } else {
            int i;
            for (i = 0; i < argLen && !commandLineError; ++i) {
                if (args[i].equals("-d")) {
                    if (i == argLen - 1) {
                        System.err.println("-d must be followed by lib directory");
                        commandLineError = true;
                        continue;
                    }
                    cmdLineProps.put(LIB_PATH_KEY, args[++i]);
                    continue;
                }
                if (args[i].equals("-b")) {
                    if (i == argLen - 1) {
                        System.err.println("-b must be followed by splash image name");
                        commandLineError = true;
                        continue;
                    }
                    cmdLineProps.put(BASE_DIR_KEY, args[++i]);
                    continue;
                }
                if (args[i].equals("-s")) {
                    if (i == argLen - 1) {
                        System.err.println("-s must be followed by splash image name");
                        commandLineError = true;
                        continue;
                    }
                    cmdLineProps.put(SPLASH_IMG_KEY, args[++i]);
                    continue;
                }
                if (args[i].equals("-c")) {
                    if (i == argLen - 1) {
                        System.err.println("-c must be followed by main class name");
                        commandLineError = true;
                        continue;
                    }
                    cmdLineProps.put(MAIN_CLASS_KEY, args[++i]);
                    continue;
                }
                if (args[i].equals("-v")) {
                    cmdLineProps.put(VERBOSE_KEY, "true");
                    continue;
                }
                if (args[i].equals("-r")) {
                    cmdLineProps.put(RECURSIVE_LIB_SEARCH_KEY, "true");
                    continue;
                }
                if (!args[i].equals("-h") && !args[i].equals("-?")) break;
                cmdLineProps.put(SHOW_HELP_KEY, "true");
            }
            if (i < argLen) {
                String[] remainingArgs = new String[argLen - i];
                System.arraycopy(args, i, remainingArgs, 0, argLen - i);
                cmdLineProps.put(EXTRA_PARAMS_KEY, remainingArgs);
            }
        }
        return commandLineError;
    }

    private static void displayUsage() {
        System.out.println("Usage:");
        System.out.println("   java [jvm args] -cp sfac-launcher-x.jar net.sf.sfac.launcher.ApplicationLauncher [-v] [-h] [-r] [-d libPath] [-e execProps] [-s splashImagePath] [-c className] [application args]");
        System.out.println(" or");
        System.out.println("   java [jvm args] -jar sfac-launcher-x.jar [-v] [-h] [-r] [-d libPath] [-e execProps] [-s splashImagePath] [-c className] [application args]");
        System.out.println("where:");
        System.out.println("   -v                  Verbose flag");
        System.out.println("   -h                  Display usage");
        System.out.println("   -e execProps        Path to execution configuration file (default = 'exec.properties')");
        System.out.println("   -b baseDir          Path of the base directory (for resolving all relative paths)");
        System.out.println("   -d libPath          Path of the directory containing jars (default = '../lib')");
        System.out.println("                       This parameter can contain several directory names separated by semicolons.");
        System.out.println("   -r                  recursive search of jars into libPath sub-directories");
        System.out.println("   -s splashImagePath  Path to the splash image in classpath (default = no splash)");
        System.out.println("   -c className           is the fully qualified name of the 'main' class of the application");
        System.out.println("   [application args]  are the parameters passed to the main method of the application");
        System.out.println("");
        System.out.println("When ApplicationLauncher is packaged as a jar, all path are relative to this jar directory");
    }

    public static File getBaseDirectory() {
        File dir = null;
        URL classUrl = ApplicationLauncher.class.getResource("ApplicationLauncher.class");
        String basePath = classUrl.getFile();
        System.out.println("Base path = " + basePath);
        int sharpIndex = basePath.indexOf(35);
        if (sharpIndex > 0) {
            File jarFile = new File(basePath.substring(0, sharpIndex));
            dir = jarFile.getAbsoluteFile().getParentFile();
        } else {
            dir = new File("");
        }
        return dir.getAbsoluteFile();
    }
}

