/*-------------------------------------------------------------------------
 Copyright 2009 Olivier Berlanger

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 -------------------------------------------------------------------------*/
package net.sf.sfac.launcher;


import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Toolkit;

import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JWindow;


public class SplashWindow extends JWindow {


    private static SplashWindow splash;

    private static boolean verbose;


    public static void showSplashWindow(String splashImageName, boolean verboseFlag) {
        verbose = verboseFlag;
        try {
            if ((splashImageName != null) && (!splashImageName.trim().equals(""))) {
                if (verboseFlag) System.out.println("Load splash image: " + splashImageName);
                splash = new SplashWindow(splashImageName);
                splash.setVisible(true);
            } else {
                if (verboseFlag) System.out.println("No splash image defined");
            }
        } catch (Exception e) {
            System.err.println("Failed to show splash window");
            e.printStackTrace();
        }
    }


    public static void hideSplashWindow() {
        if (splash != null) {
            splash.setVisible(false);
            splash.dispose();
        }
    }


    public SplashWindow(String splashImageName) {
        if (verbose) System.out.println("Splash image = " + splashImageName);
        ImageIcon splashImage = new ImageIcon(getClass().getResource(splashImageName));
        JLabel splashLabel = new JLabel(splashImage);
        getContentPane().add(splashLabel, BorderLayout.CENTER);
        int imageWidth = splashImage.getIconWidth();
        int imageHeight = splashImage.getIconHeight();
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        setBounds((screenDim.width - imageWidth) / 2, (screenDim.height - imageHeight) / 2, imageWidth, imageHeight);
    }

}
