/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.launcher;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.sfac.launcher.SplashWindow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationLauncher {
    private boolean verboseOutput;
    private boolean recursive;
    private List<File> libDirs;
    private URLClassLoader classLoader;

    public ApplicationLauncher(List<File> libDirectories, boolean verbose, boolean recursiveSearch) {
        this.libDirs = libDirectories;
        this.verboseOutput = verbose;
        this.recursive = recursiveSearch;
        this.configureClassLoader();
    }

    private void configureClassLoader() {
        ArrayList<URL> jarUrls = new ArrayList<URL>();
        for (File libDir : this.libDirs) {
            this.addJars(libDir, jarUrls);
        }
        URL[] urls = jarUrls.toArray(new URL[jarUrls.size()]);
        this.classLoader = new URLClassLoader(urls, this.getClass().getClassLoader());
        Thread.currentThread().setContextClassLoader(this.classLoader);
        if (this.verboseOutput) {
            System.out.println("URL class loader created: " + this.classLoader);
        }
    }

    private void addJars(File libDir, List<URL> jarUrls) {
        if (this.verboseOutput) {
            System.out.println("Add libraries from: " + libDir);
        }
        for (File fil : libDir.listFiles()) {
            if (fil.isDirectory()) {
                if (!this.recursive) continue;
                this.addJars(fil, jarUrls);
                continue;
            }
            if (!fil.getName().endsWith(".jar")) continue;
            try {
                if (this.verboseOutput) {
                    System.out.println("   * " + fil);
                }
                jarUrls.add(fil.toURI().toURL());
            }
            catch (Exception e) {
                System.err.println("Unable to build URL for file: " + fil);
                e.printStackTrace();
            }
        }
    }

    public void startApplication(String className, String[] remainingArgs) throws Exception {
        if (this.verboseOutput) {
            System.out.println("Launch class " + className);
            System.out.println("    args = " + Arrays.toString(remainingArgs));
        }
        Class<?> clazz = this.classLoader.loadClass(className);
        Method main = clazz.getDeclaredMethod("main", String[].class);
        main.invoke(null, new Object[]{remainingArgs});
    }

    public static void main(String[] args) {
        int argLen;
        boolean displayUsage = false;
        boolean verbose = false;
        boolean recursive = false;
        String splashImageName = null;
        String className = null;
        String[] remainingArgs = new String[]{};
        ArrayList<File> libDirectories = new ArrayList<File>();
        int n = argLen = args == null ? 0 : args.length;
        if (argLen == 0) {
            System.err.println("No parameter defined !");
            displayUsage = true;
        } else {
            int i;
            for (i = 0; className == null && i < argLen && !displayUsage; ++i) {
                if (args[i].equals("-d")) {
                    if (i == argLen - 1) {
                        System.err.println("-d must be followed by lib directory");
                        displayUsage = true;
                        continue;
                    }
                    displayUsage = ApplicationLauncher.addDirectories(args[++i], libDirectories);
                    continue;
                }
                if (args[i].equals("-s")) {
                    if (i == argLen - 1) {
                        System.err.println("-s must be followed by splash image name");
                        displayUsage = true;
                        continue;
                    }
                    splashImageName = args[++i];
                    continue;
                }
                if (args[i].equals("-v")) {
                    verbose = true;
                    continue;
                }
                if (args[i].equals("-r")) {
                    recursive = true;
                    continue;
                }
                if (args[i].equals("-h") || args[i].equals("-?")) {
                    displayUsage = true;
                    continue;
                }
                className = args[i];
            }
            if (i < argLen) {
                remainingArgs = new String[argLen - i];
                System.arraycopy(args, i, remainingArgs, 0, argLen - i);
            }
        }
        if (libDirectories.size() == 0) {
            libDirectories.add(new File("../lib").getAbsoluteFile());
        }
        if (displayUsage) {
            ApplicationLauncher.displayUsage();
        } else {
            try {
                SplashWindow.showSplashWindow(splashImageName, verbose);
                ApplicationLauncher launcher = new ApplicationLauncher(libDirectories, verbose, recursive);
                launcher.startApplication(className, remainingArgs);
                SplashWindow.hideSplashWindow();
            }
            catch (Exception e) {
                System.err.println("Failed to start application: " + className);
                e.printStackTrace();
            }
        }
    }

    private static boolean addDirectories(String allDirsString, List<File> dirs) {
        String[] dirsString;
        if (allDirsString == null || allDirsString.trim().equals("")) {
            System.err.println("Lib directory is mandatory after -d");
            return true;
        }
        for (String dirString : dirsString = allDirsString.split(";")) {
            File libDirectory = new File(dirString);
            if (!libDirectory.exists()) {
                System.err.println("Lib directory '" + libDirectory + "' not found");
                return true;
            }
            if (!libDirectory.isDirectory()) {
                System.err.println("-d must be followed by a directory (bad value: '" + libDirectory + "')");
                return true;
            }
            try {
                libDirectory = libDirectory.getCanonicalFile();
            }
            catch (Exception e) {
                System.err.println("Cannot canonicalize lib directory: '" + libDirectory + "'");
                e.printStackTrace();
                return true;
            }
            dirs.add(libDirectory);
        }
        return false;
    }

    private static void displayUsage() {
        System.out.println("Usage:");
        System.out.println("   java [jvm args] net.sf.sfac.launcher.ApplicationLauncher [-v] [-h] [-r] [-d libPath] [-s splashImagePath] <className> [application args]");
        System.out.println("where:");
        System.out.println("   -v                  Verbose flag");
        System.out.println("   -h                  Display usage");
        System.out.println("   -d libPath          Path of the directory containing jars (default = '../lib')");
        System.out.println("                       This parameter can contain several directory names separated by semicolons.");
        System.out.println("   -r                  recursive search of jars into libPath sub-directories");
        System.out.println("   -s splashImagePath  Path to the splash image in classpath (default = no splash)");
        System.out.println("   <className>         is the fully qualified name of the 'main' class of the application");
        System.out.println("   [application args]  are the parameters passed to the main method of the application");
    }
}

