/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.launcher;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JWindow;

public class SplashWindow
extends JWindow {
    private static SplashWindow splash;
    private static boolean verbose;

    public static void showSplashWindow(String splashImageName, boolean verboseFlag) {
        verbose = verboseFlag;
        try {
            if (splashImageName != null && !splashImageName.trim().equals("")) {
                if (verboseFlag) {
                    System.out.println("Load splash image: " + splashImageName);
                }
                splash = new SplashWindow(splashImageName);
                splash.setVisible(true);
            } else if (verboseFlag) {
                System.out.println("No splash image defined");
            }
        }
        catch (Exception e) {
            System.err.println("Failed to show splash window");
            e.printStackTrace();
        }
    }

    public static void hideSplashWindow() {
        if (splash != null) {
            splash.setVisible(false);
            splash.dispose();
        }
    }

    public SplashWindow(String splashImageName) {
        if (verbose) {
            System.out.println("Splash image = " + splashImageName);
        }
        ImageIcon splashImage = new ImageIcon(this.getClass().getResource(splashImageName));
        JLabel splashLabel = new JLabel(splashImage);
        this.getContentPane().add((Component)splashLabel, "Center");
        int imageWidth = splashImage.getIconWidth();
        int imageHeight = splashImage.getIconHeight();
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenDim.width - imageWidth) / 2, (screenDim.height - imageHeight) / 2, imageWidth, imageHeight);
    }
}

