/*
 * Decompiled with CFR 0.152.
 */
package net.sf.seide.ext.spring3;

import java.util.LinkedList;
import java.util.Map;
import net.sf.seide.core.Dispatcher;
import net.sf.seide.ext.spring3.DefaultDispatcherFactory;
import net.sf.seide.ext.spring3.DispatcherFactory;
import net.sf.seide.stages.Stage;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class DispatcherFactoryBean
implements FactoryBean<Dispatcher>,
ApplicationContextAware,
DisposableBean {
    private ApplicationContext applicationContext;
    private String context;
    private Dispatcher dispatcher;
    private DispatcherFactory dispatcherFactory = DefaultDispatcherFactory.createDefault();

    public Dispatcher getObject() throws Exception {
        if (this.dispatcher != null) {
            return this.dispatcher;
        }
        LinkedList<Stage> stages = new LinkedList<Stage>();
        Map beansOfType = this.applicationContext.getBeansOfType(Stage.class, true, false);
        for (Stage stage : beansOfType.values()) {
            if (!stage.getContext().trim().equalsIgnoreCase(this.context)) continue;
            stages.add(stage);
        }
        Dispatcher newDispatcher = this.dispatcherFactory.create();
        newDispatcher.setStages(stages);
        newDispatcher.setContext(this.context);
        newDispatcher.start();
        this.dispatcher = newDispatcher;
        return this.dispatcher;
    }

    public Class<?> getObjectType() {
        return Dispatcher.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public String getContext() {
        return this.context;
    }

    @Required
    public void setContext(String context) {
        this.context = context;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void destroy() throws Exception {
        this.dispatcher.stop();
    }
}

