/*
 * Decompiled with CFR 0.152.
 */
package net.sf.seide.event;

import java.util.ArrayList;
import java.util.Collection;
import net.sf.seide.core.Dispatcher;
import net.sf.seide.core.RuntimeStage;
import net.sf.seide.event.Event;
import net.sf.seide.event.EventHandler;
import net.sf.seide.message.JoinHandler;
import net.sf.seide.message.Message;
import net.sf.seide.stages.RoutingOutcome;
import net.sf.seide.stages.StageStatistics;

public class RunnableEventHandlerWrapper
implements Runnable {
    private final Dispatcher dispatcher;
    private final RuntimeStage runtimeStage;
    private final Message message;
    private final StageStatistics stageStats;
    private final StageStatistics routingStageStats;
    private final EventHandler eventHandler;
    private final Event event;

    public RunnableEventHandlerWrapper(Dispatcher dispatcher, RuntimeStage runtimeStage, Event event) {
        this.dispatcher = dispatcher;
        this.runtimeStage = runtimeStage;
        this.message = event.getMessage();
        this.stageStats = runtimeStage.getStageStats();
        this.routingStageStats = runtimeStage.getRoutingStageStats();
        this.eventHandler = runtimeStage.getEventHandler();
        this.event = event;
        this.stageStats.addPending();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.stageStats.removePending();
        this.stageStats.addRunning();
        long time = 0L;
        time = System.nanoTime();
        Message returnMessage = null;
        try {
            RoutingOutcome routingOutcome = this.eventHandler.execute(this.message);
            this.stageStats.trackTimeAndExecution(System.nanoTime() - time);
            this.stageStats.removeRunning();
            this.routingStageStats.addRunning();
            time = System.nanoTime();
            if (routingOutcome != null) {
                returnMessage = routingOutcome.getReturnMessage();
                if (!routingOutcome.isEmpty()) {
                    Collection<Event> outcomeEvents = routingOutcome.getEvents();
                    if (routingOutcome.hasJoinEvent()) {
                        outcomeEvents = this.createJoinEventAttachedOf(outcomeEvents, routingOutcome.getJoinEvent());
                    }
                    this.fireEvents(outcomeEvents);
                }
            }
            this.routingStageStats.trackTimeAndExecution(System.nanoTime() - time);
            this.routingStageStats.removeRunning();
            JoinHandler joinHandler = this.event.getJoinHandler();
            if (joinHandler != null) {
                joinHandler.notifyChildOutcome(this.getRuntimeStage().getId(), returnMessage);
            }
        }
        catch (Throwable throwable) {
            this.routingStageStats.trackTimeAndExecution(System.nanoTime() - time);
            this.routingStageStats.removeRunning();
            JoinHandler joinHandler = this.event.getJoinHandler();
            if (joinHandler != null) {
                joinHandler.notifyChildOutcome(this.getRuntimeStage().getId(), returnMessage);
            }
            throw throwable;
        }
    }

    private Collection<Event> createJoinEventAttachedOf(Collection<Event> outcomeEvents, Event targetEvent) {
        ArrayList<Event> joinEventWrappedCollection = new ArrayList<Event>(outcomeEvents.size());
        JoinHandler joinHandler = new JoinHandler(this.dispatcher, targetEvent);
        for (Event event : outcomeEvents) {
            joinEventWrappedCollection.add(new Event(event, joinHandler));
            joinHandler.registerChild(this.eventHandler);
        }
        return joinEventWrappedCollection;
    }

    private void fireEvents(Collection<Event> outcomeEvents) {
        for (Event e : outcomeEvents) {
            this.dispatcher.execute(e);
        }
    }

    public RuntimeStage getRuntimeStage() {
        return this.runtimeStage;
    }
}

