/*
 * Decompiled with CFR 0.152.
 */
package net.sf.seide.stages.impl;

import java.util.concurrent.atomic.AtomicLong;
import net.sf.seide.stages.StageStatistics;

public class StageStatisticsImpl
implements StageStatistics {
    private final String context;
    private final String id;
    private final AtomicLong pending = new AtomicLong(0L);
    private final AtomicLong running = new AtomicLong(0L);
    private final AtomicLong totalExecutions = new AtomicLong(0L);
    private final AtomicLong totalExecutionTime = new AtomicLong(0L);
    private final AtomicLong minExecutionTime = new AtomicLong(-1L);
    private final AtomicLong maxExecutionTime = new AtomicLong(-1L);
    private final AtomicLong discardedExecutions = new AtomicLong(0L);
    private final AtomicLong errors = new AtomicLong(0L);

    public StageStatisticsImpl(String context, String id) {
        this.context = context;
        this.id = id;
    }

    @Override
    public String getContext() {
        return this.context;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public long getPendingCount() {
        return this.pending.get();
    }

    @Override
    public long getRunningCount() {
        return this.running.get();
    }

    @Override
    public long getTotalExecutionCount() {
        return this.totalExecutions.get();
    }

    @Override
    public long getTotalExecutionTime() {
        return this.totalExecutionTime.get();
    }

    @Override
    public long getMinExecutionTime() {
        return this.minExecutionTime.get();
    }

    @Override
    public long getMaxExecutionTime() {
        return this.maxExecutionTime.get();
    }

    @Override
    public double getAvgExecutionTime() {
        long count = this.totalExecutions.get();
        if (count > 0L) {
            return (double)(this.totalExecutionTime.get() / count) * 1.0;
        }
        return 0.0;
    }

    @Override
    public void addPending() {
        this.pending.incrementAndGet();
    }

    @Override
    public void removePending() {
        this.pending.decrementAndGet();
    }

    @Override
    public void addRunning() {
        this.running.incrementAndGet();
    }

    @Override
    public void removeRunning() {
        this.running.decrementAndGet();
    }

    @Override
    public long getDiscardedExecutions() {
        return this.discardedExecutions.get();
    }

    @Override
    public long getRetryedExecutions() {
        return 0L;
    }

    @Override
    public void trackRetry() {
    }

    @Override
    public void trackDiscardedExecution() {
        this.discardedExecutions.incrementAndGet();
    }

    @Override
    public void trackTimeAndExecution(long timeInNanos) {
        long safe;
        this.totalExecutions.incrementAndGet();
        long time = timeInNanos / 1000L;
        this.totalExecutionTime.addAndGet(time);
        if (!this.minExecutionTime.compareAndSet(-1L, time) && time < (safe = this.minExecutionTime.get())) {
            this.minExecutionTime.compareAndSet(safe, time);
        }
        if (!this.maxExecutionTime.compareAndSet(-1L, time) && time > (safe = this.maxExecutionTime.get())) {
            this.maxExecutionTime.compareAndSet(safe, time);
        }
    }

    @Override
    public void trackTimeAndExecution(long time, boolean error) {
        this.trackTimeAndExecution(time);
        if (error) {
            this.errors.incrementAndGet();
        }
    }
}

