/*
 * Decompiled with CFR 0.152.
 */
package net.sf.seam.perf4j;

import org.jboss.seam.log.Log;
import org.jboss.seam.log.Logging;
import org.perf4j.LoggingStopWatch;

public class SeamLoggerStopWatch
extends LoggingStopWatch {
    public static final LoggingLevel DEFAULT_NORMAL_PRIORITY = LoggingLevel.INFO;
    public static final LoggingLevel DEFAULT_EXCEPTION_PRIORITY = LoggingLevel.WARN;
    private transient Log logger;
    private LoggingLevel normalPriority;
    private LoggingLevel exceptionPriority;

    public SeamLoggerStopWatch() {
        this(DEFAULT_NORMAL_PRIORITY);
    }

    public SeamLoggerStopWatch(LoggingLevel normalPriority) {
        this(normalPriority, DEFAULT_EXCEPTION_PRIORITY);
    }

    public SeamLoggerStopWatch(LoggingLevel normalPriority, LoggingLevel exceptionPriority) {
        this(Logging.getLog((String)"org.perf4j.TimingLogger"), normalPriority, exceptionPriority);
    }

    public SeamLoggerStopWatch(String normalPriority) {
        this(LoggingLevel.safeValueOf(normalPriority, DEFAULT_NORMAL_PRIORITY));
    }

    public SeamLoggerStopWatch(String normalPriority, String exceptionPriority) {
        this(LoggingLevel.safeValueOf(normalPriority, DEFAULT_NORMAL_PRIORITY), LoggingLevel.safeValueOf(exceptionPriority, DEFAULT_EXCEPTION_PRIORITY));
    }

    public SeamLoggerStopWatch(Log logger) {
        this(logger, DEFAULT_NORMAL_PRIORITY);
    }

    public SeamLoggerStopWatch(Log logger, String normalPriority) {
        this(logger, LoggingLevel.safeValueOf(normalPriority, DEFAULT_NORMAL_PRIORITY));
    }

    public SeamLoggerStopWatch(Log logger, String normalPriority, String exceptionPriority) {
        this(logger, LoggingLevel.safeValueOf(normalPriority, DEFAULT_NORMAL_PRIORITY), LoggingLevel.safeValueOf(exceptionPriority, DEFAULT_EXCEPTION_PRIORITY));
    }

    public SeamLoggerStopWatch(Log logger, LoggingLevel normalPriority) {
        this(logger, normalPriority, DEFAULT_EXCEPTION_PRIORITY);
    }

    public SeamLoggerStopWatch(Log logger, LoggingLevel normalPriority, LoggingLevel exceptionPriority) {
        if (logger == null) {
            throw new IllegalArgumentException("logger cannot be null!");
        }
        this.logger = logger;
        this.normalPriority = normalPriority;
        this.exceptionPriority = exceptionPriority;
    }

    public Log getLogger() {
        return this.logger;
    }

    public LoggingLevel getNormalPriority() {
        return this.normalPriority;
    }

    public LoggingLevel getExceptionPriority() {
        return this.exceptionPriority;
    }

    public boolean isLogging() {
        switch (this.normalPriority) {
            case FATAL: {
                return this.logger.isFatalEnabled();
            }
            case ERROR: {
                return this.logger.isErrorEnabled();
            }
            case WARN: {
                return this.logger.isWarnEnabled();
            }
            case INFO: {
                return this.logger.isInfoEnabled();
            }
            case DEBUG: {
                return this.logger.isDebugEnabled();
            }
            case TRACE: {
                return this.logger.isTraceEnabled();
            }
        }
        return true;
    }

    protected void log(String stopWatchAsString, Throwable exception) {
        LoggingLevel requiredPriority = exception == null ? this.normalPriority : this.exceptionPriority;
        switch (requiredPriority) {
            case FATAL: {
                this.logger.fatal((Object)stopWatchAsString, exception, new Object[0]);
                break;
            }
            case ERROR: {
                this.logger.error((Object)stopWatchAsString, exception, new Object[0]);
                break;
            }
            case WARN: {
                this.logger.warn((Object)stopWatchAsString, exception, new Object[0]);
                break;
            }
            default: {
                this.logger.info((Object)stopWatchAsString, exception, new Object[0]);
                break;
            }
            case DEBUG: {
                this.logger.debug((Object)stopWatchAsString, exception, new Object[0]);
                break;
            }
            case TRACE: {
                this.logger.trace((Object)stopWatchAsString, exception, new Object[0]);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LoggingLevel {
        FATAL,
        ERROR,
        WARN,
        INFO,
        DEBUG,
        TRACE;


        public static LoggingLevel safeValueOf(String name, LoggingLevel defaultLevel) {
            try {
                return LoggingLevel.valueOf(name);
            }
            catch (IllegalArgumentException e) {
                return defaultLevel;
            }
        }
    }
}

