<?xml version="1.0" encoding="UTF-8"?>
<stylesheet
	xmlns="http://www.w3.org/1999/XSL/Transform"
	xmlns:xs="http://www.w3.org/2001/XMLSchema"
	xmlns:seaf="http://seaf.sf.net/seaf"
	version="2.0">

	<!-- New line constant -->
	<variable name="nl">
		<text>
</text>
	</variable>

	<!-- Tab constant -->
	<variable name="tab">
		<text>	</text>
	</variable>

	<!-- New line with 4 tabs constant -->
	<variable name="nl4">
		<text>
				</text>
	</variable>

	<!-- Copy template -->
	<template match="@*|node()|text()" mode="copy">
		<copy>
			<apply-templates select="@*|node()|text()" mode="copy" />
		</copy>
	</template>

	<!-- Convert first letter to upper case -->
	<function name="seaf:first-upper" as="xs:string">
		<param name="word" as="xs:string" />
		<value-of
			select="concat(upper-case(substring($word,1,1)),substring($word,2))" />
	</function>

	<!-- Convert first letter to lower case -->
	<function name="seaf:first-lower" as="xs:string">
		<param name="word" as="xs:string" />
		<value-of
			select="concat(lower-case(substring($word,1,1)),substring($word,2))" />
	</function>

	<!-- Return true iff first letter is lower case and second letter is upper case -->
	<function name="seaf:is-lower-upper" as="xs:boolean">
		<param name="name" as="xs:string" />
		<variable name="first" select="substring($name,1,1)" />
		<variable name="second" select="substring($name,2,1)" />
		<value-of select="(lower-case($first)=$first) and (upper-case($second)=$second)" />
	</function>

	<!-- Convert first letter to upper case, the JavaBeans style -->
	<function name="seaf:java-beans-first-upper" as="xs:string">
		<param name="name" as="xs:string" />
		<choose>
		<when test="seaf:is-lower-upper($name)">
			<value-of select="$name" />
		</when>
		<otherwise>
			<value-of select="seaf:first-upper($name)" />
		</otherwise>
		</choose>
	</function>

	<!-- Join words using the camel notation -->
	<function name="seaf:camel" as="xs:string">
		<param name="words" as="xs:string" />
		<variable name="words-lower" select="lower-case($words)" />
		<value-of
			select="if(contains($words-lower,' ')) 
			then concat(
				seaf:first-upper(substring-before($words-lower,' ')),
				seaf:camel(substring-after($words-lower,' '))) 
			else seaf:first-upper($words-lower)" />
	</function>

	<!-- Return the last token of a value, given the tokens' separator -->
	<function name="seaf:last-token" as="xs:string">
		<param name="value" as="xs:string" />
		<param name="separator" as="xs:string" />
		<variable name="tokens" select="tokenize($value,$separator)" />
		<value-of select="subsequence($tokens,count($tokens))" />
	</function>

	<!-- Cut-off the last token from a value, given the tokens' separator -->
	<function name="seaf:strip-last-token" as="xs:string">
		<param name="value" as="xs:string" />
		<param name="separate" as="xs:string" />
		<param name="join" as="xs:string" />
		<variable name="tokens" select="tokenize($value,$separate)" />
		<value-of
			select="string-join(subsequence($tokens,1,count($tokens)-1),$join)" />
	</function>

	<!-- Return HTML hyper-link -->
	<function name="seaf:hyperlink" as="xs:string*">
		<param name="link" as="xs:string" />
		<param name="label" as="xs:string" />
		<value-of select="concat('&lt;a href=&quot;',$link,'&quot;>',$label,'&lt;/a>')"/>
	</function>

	<!-- Convert English singular word into plural -->
	<function name="seaf:plural" as="xs:string">
		<param name="word" as="xs:string" />
		<choose>
		<when test="ends-with($word,'s')">
			<value-of select="$word" />
		</when>
		<otherwise>
			<value-of select="concat($word,'s')"/>
		</otherwise>
		</choose>
	</function>

</stylesheet>
