/*
 * Decompiled with CFR 0.152.
 */
package net.sf.seaf.util.convert.simple;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import net.sf.seaf.util.TemporalConverterUtil;
import net.sf.seaf.util.convert.simple.TemporalType;

public class ConverterToString {
    public static String convert(Object o) {
        return null == o ? null : String.valueOf(o);
    }

    public static String convert(Object o, TemporalType type) {
        Calendar cal;
        if (null == o) {
            return null;
        }
        String format = ConverterToString.getFormatByType(type);
        if (o instanceof Date) {
            cal = new GregorianCalendar();
            cal.setTime((Date)o);
        } else if (o instanceof Calendar) {
            cal = (Calendar)o;
        } else {
            return ConverterToString.convert(o);
        }
        return TemporalConverterUtil.formatDate(cal, format);
    }

    private static String getFormatByType(TemporalType type) {
        if (TemporalType.DATE.equals((Object)type)) {
            return "yyyy-MM-dd";
        }
        if (TemporalType.DATETIME.equals((Object)type)) {
            return "yyyy-MM-dd'T'HH:mm:ss";
        }
        if (TemporalType.TIME.equals((Object)type)) {
            return "HH:mm:ss";
        }
        return "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    }
}

