/*
 * Decompiled with CFR 0.152.
 */
package net.sf.seaf.util.convert.collection;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.sf.seaf.exception.SeafConversionException;
import net.sf.seaf.util.convert.collection.CollectionConverter;
import net.sf.seaf.util.convert.collection.ObjectConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceConverterUtils {
    public Object convert(Object sourceValue, Class<?> targetType, Class<?> targetComponentType, ObjectConverter<Object, Object> objectConverter) {
        if (targetType.isArray()) {
            return this.convertToArray(sourceValue, targetComponentType, objectConverter);
        }
        return this.convertToList(sourceValue, targetComponentType, objectConverter);
    }

    public Object[] convertToArray(Object sourceValue, Class<?> targetComponentType, ObjectConverter<Object, Object> objectConverter) {
        Collection<Object> sourceCollection;
        ArrayList targetCollection = new ArrayList();
        Class<?> sourceType = sourceValue.getClass();
        if (sourceType.isArray() && Object.class.isAssignableFrom(sourceType.getComponentType())) {
            sourceCollection = Arrays.asList((Object[])sourceValue);
        } else if (Collection.class.isAssignableFrom(sourceType)) {
            sourceCollection = this.castToCollectionObject(sourceValue);
        } else {
            throw new SeafConversionException("Source value is of unsupported type: " + sourceType);
        }
        new CollectionConverter<Object, Object>().convert(sourceCollection, targetCollection, objectConverter);
        Object[] targetArray = targetCollection.toArray((Object[])Array.newInstance(targetComponentType, 0));
        return targetArray;
    }

    public List<Object> convertToList(Object sourceValue, Class<?> targetComponentType, ObjectConverter<Object, Object> objectConverter) {
        Object[] targetArray = this.convertToArray(sourceValue, targetComponentType, objectConverter);
        return Arrays.asList(targetArray);
    }

    private Collection<Object> castToCollectionObject(Object sourceValue) {
        return (Collection)sourceValue;
    }
}

