/*
 * Decompiled with CFR 0.152.
 */
package net.sf.seaf.util;

import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToStringUtils {
    private final StringBuilder b;
    private boolean firstProperty = true;

    public ToStringUtils(Class<?> clazz, String superToString) {
        this.b = new StringBuilder(clazz.getName());
        this.b.append('[');
        Class<?> superClass = clazz.getSuperclass();
        if (null != superClass && !"java.lang.Object".equals(superClass.getName())) {
            this.b.append('[');
            this.b.append(superToString);
            this.b.append(']');
        }
    }

    public void addProperty(String name, Object value) {
        if (this.firstProperty) {
            this.firstProperty = false;
        } else {
            this.b.append(',');
        }
        this.b.append(name);
        this.b.append('=');
        this.appendValue(value);
    }

    private void appendValue(Object value) {
        if (value instanceof byte[]) {
            this.appendArray(value.getClass().getComponentType(), ((byte[])value).length, new Object[0]);
        } else if (value instanceof int[]) {
            this.appendArray(value.getClass().getComponentType(), ((int[])value).length, new Object[0]);
        } else if (value instanceof long[]) {
            this.appendArray(value.getClass().getComponentType(), ((long[])value).length, new Object[0]);
        } else if (value instanceof char[]) {
            this.appendArray(value.getClass().getComponentType(), ((char[])value).length, new Object[0]);
        } else if (value instanceof float[]) {
            this.appendArray(value.getClass().getComponentType(), ((float[])value).length, new Object[0]);
        } else if (value instanceof double[]) {
            this.appendArray(value.getClass().getComponentType(), ((double[])value).length, new Object[0]);
        } else if (value instanceof Object[]) {
            this.appendArray(value.getClass().getComponentType(), (Object[])value);
        } else if (value instanceof Collection) {
            this.appendArray(value.getClass(), ((Collection)value).toArray());
        } else {
            this.b.append(String.valueOf(value));
        }
    }

    private void appendArray(Class<?> clazz, Object[] items) {
        this.appendArray(clazz, items.length, items);
    }

    private void appendArray(Class<?> clazz, int displayLength, Object[] items) {
        this.b.append(clazz.getName());
        this.b.append('#');
        this.b.append(displayLength);
        this.b.append('[');
        for (int i = 0; i < items.length; ++i) {
            this.b.append(items[i]);
            if (i >= items.length - 1) continue;
            this.b.append(',');
        }
        this.b.append(']');
    }

    public String toString() {
        this.b.append(']');
        return this.b.toString();
    }
}

