/*
 * Decompiled with CFR 0.152.
 */
package net.sf.seaf.util;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class TemporalConverterUtil {
    public static Calendar convert(Object o, String format) throws IllegalArgumentException {
        if (null == o) {
            return null;
        }
        if (o instanceof Date) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime((Date)o);
            return cal;
        }
        if (o instanceof Calendar) {
            return (Calendar)o;
        }
        return TemporalConverterUtil.parseDate(o.toString(), format);
    }

    public static Calendar parseDate(String text, String format) throws IllegalArgumentException {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        ParsePosition pos = new ParsePosition(0);
        Date date = formatter.parse(text, pos);
        if (null == date) {
            throw new IllegalArgumentException("Value " + text + " cannot be parsed as " + format);
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        TemporalConverterUtil.backwardValidationOfStringValue(text, cal, format);
        return cal;
    }

    public static void backwardValidationOfStringValue(String originalValue, Calendar parsedValue, String format) throws IllegalArgumentException {
        String result = TemporalConverterUtil.formatDate(parsedValue, format);
        if (!originalValue.equals(result)) {
            throw new IllegalArgumentException("Value " + originalValue + " is not valid.");
        }
    }

    public static String formatDate(Calendar value, String format) {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        return formatter.format(value.getTime());
    }
}

