/*
 * Decompiled with CFR 0.152.
 */
package net.sf.seaf.util;

import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import net.sf.seaf.util.convert.simple.ConverterToString;
import net.sf.seaf.util.convert.simple.TemporalType;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class RecursiveReflectionToStringStyle
extends ToStringStyle {
    private static final long serialVersionUID = 1L;
    public static final RecursiveReflectionToStringStyle DEFAULT_RR_STYLE = new RecursiveReflectionToStringStyle();
    public static final RecursiveReflectionToStringStyle SIMPLE_RR_STYLE = new SimpleRecursiveReflectionToStringStyle();

    private RecursiveReflectionToStringStyle() {
        this.setSizeStartText("{#");
        this.setSizeEndText("}");
        this.setUseShortClassName(false);
        this.setUseIdentityHashCode(true);
    }

    protected void appendDetail(StringBuffer buffer, String fieldName, byte[] array) {
        this.appendSummary(buffer, fieldName, array);
    }

    protected void appendSummarySize(StringBuffer buffer, String fieldName, int size) {
        buffer.append(this.getSizeStartText());
        buffer.append(size);
        buffer.append(this.getSizeEndText());
    }

    protected void appendDetail(StringBuffer buffer, String fieldName, Map map) {
        buffer.append(Map.class.getName());
        this.appendDetail(buffer, fieldName, map.entrySet().toArray());
    }

    protected void appendDetail(StringBuffer buffer, String fieldName, Collection coll) {
        buffer.append(Collection.class.getName());
        if (this.isArrayContentDetail()) {
            this.appendDetail(buffer, fieldName, coll.toArray());
        } else {
            this.appendSummary(buffer, fieldName, coll.toArray());
        }
    }

    protected void appendDetail(StringBuffer buffer, String fieldName, Object value) {
        if (this.isBaseType(value)) {
            this.appendBaseType(buffer, fieldName, value);
        } else if (this.isHashMapEntry(value)) {
            this.appendDetail(buffer, fieldName, (Map.Entry)value);
        } else if (this.isDate(value)) {
            super.appendDetail(buffer, fieldName, (Object)ConverterToString.convert(value, TemporalType.TIMESTAMP));
        } else {
            new ReflectionToStringBuilder(value, (ToStringStyle)this, buffer).toString();
        }
    }

    private void appendBaseType(StringBuffer buffer, String fieldName, Object value) {
        if (this.isString(value)) {
            this.appendDetail(buffer, fieldName, (String)value);
        } else if (this.isChar(value)) {
            this.appendDetail(buffer, fieldName, (Character)value);
        } else {
            super.appendDetail(buffer, fieldName, value);
        }
    }

    protected void appendDetail(StringBuffer buffer, String fieldName, String value) {
        value = value.replaceAll("\u0000", "");
        super.appendDetail(buffer, fieldName, (Object)value);
    }

    protected void appendDetail(StringBuffer buffer, String fieldName, Character value) {
        if (value.equals(Character.valueOf('\u0000'))) {
            super.appendDetail(buffer, fieldName, (Object)this.getNullText());
        } else {
            super.appendDetail(buffer, fieldName, (Object)value);
        }
    }

    protected void appendDetail(StringBuffer buffer, String fieldName, Map.Entry hashMapEntry) {
        super.appendDetail(buffer, fieldName, hashMapEntry.getKey());
        buffer.append(this.getFieldNameValueSeparator());
        this.appendInternal(buffer, fieldName, hashMapEntry.getValue(), true);
    }

    private boolean isChar(Object value) {
        return value instanceof Character;
    }

    private boolean isString(Object value) {
        return value instanceof String;
    }

    private boolean isDate(Object value) {
        return value instanceof Date || value instanceof Calendar;
    }

    private boolean isHashMapEntry(Object value) {
        return value instanceof Map.Entry;
    }

    private boolean isBaseType(Object value) {
        return value.getClass().isPrimitive() || value instanceof String || value instanceof Number || value instanceof Boolean || value instanceof Character;
    }

    private static class SimpleRecursiveReflectionToStringStyle
    extends RecursiveReflectionToStringStyle {
        private static final long serialVersionUID = 1L;

        public SimpleRecursiveReflectionToStringStyle() {
            this.setUseIdentityHashCode(false);
        }
    }
}

