/*
 * Decompiled with CFR 0.152.
 */
package net.sf.seaf.util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashCodeUtils {
    private static final int SEED = 23;
    private static final int ODD_PRIME_NUMBER = 37;

    public static int hashCodeFor(Object ... values) {
        return HashCodeUtils.hashObject(23, values);
    }

    private static int hashObject(int aSeed, Object anObject) {
        int result = aSeed;
        if (anObject == null) {
            result = HashCodeUtils.hashOtherHashCode(result, 0);
        } else if (HashCodeUtils.isArrayOfType(anObject, Integer.TYPE)) {
            int[] array = (int[])anObject;
            for (int i = 0; i < array.length; ++i) {
                result = HashCodeUtils.hashObject(result, array[i]);
            }
        } else if (HashCodeUtils.isArrayOfType(anObject, Long.TYPE)) {
            long[] array = (long[])anObject;
            for (int i = 0; i < array.length; ++i) {
                result = HashCodeUtils.hashObject(result, array[i]);
            }
        } else if (HashCodeUtils.isArrayOfType(anObject, Byte.TYPE)) {
            byte[] array = (byte[])anObject;
            for (int i = 0; i < array.length; ++i) {
                result = HashCodeUtils.hashObject(result, array[i]);
            }
        } else if (HashCodeUtils.isArrayOfType(anObject, Character.TYPE)) {
            char[] array = (char[])anObject;
            for (int i = 0; i < array.length; ++i) {
                result = HashCodeUtils.hashObject(result, Character.valueOf(array[i]));
            }
        } else if (HashCodeUtils.isArrayOfType(anObject, Float.TYPE)) {
            float[] array = (float[])anObject;
            for (int i = 0; i < array.length; ++i) {
                result = HashCodeUtils.hashObject(result, Float.valueOf(array[i]));
            }
        } else if (HashCodeUtils.isArrayOfType(anObject, Double.TYPE)) {
            double[] array = (double[])anObject;
            for (int i = 0; i < array.length; ++i) {
                result = HashCodeUtils.hashObject(result, array[i]);
            }
        } else if (HashCodeUtils.isArray(anObject)) {
            Object[] array = (Object[])anObject;
            for (int i = 0; i < array.length; ++i) {
                result = HashCodeUtils.hashObject(result, array[i]);
            }
        } else {
            result = HashCodeUtils.hashOtherHashCode(result, anObject.hashCode());
        }
        return result;
    }

    private static int hashOtherHashCode(int aSeed, int otherHashCode) {
        return 37 * aSeed + otherHashCode;
    }

    private static boolean isArray(Object anObject) {
        return anObject.getClass().isArray();
    }

    private static boolean isArrayOfType(Object anObject, Class<?> type) {
        return HashCodeUtils.isArray(anObject) && anObject.getClass().getComponentType().equals(type);
    }
}

