/*
 * Decompiled with CFR 0.152.
 */
package net.sf.seaf.util;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class Generator {
    public static final double[] LETTER_FREQS = new double[]{0.08167, 0.09659, 0.12441, 0.16694, 0.29396, 0.31624, 0.33639, 0.39733, 0.46699, 0.46852, 0.47624, 0.51649, 0.54055, 0.60804, 0.68311, 0.7024, 0.70335, 0.76322, 0.82649, 0.91705, 0.94463, 0.95441, 0.97801, 0.97951, 0.99925};

    public int numberExcl(int min, int max) {
        double r = Math.random();
        return (int)(r * (double)(max - min)) + min;
    }

    public int numberIncl(int min, int max) {
        return this.numberExcl(min, max + 1);
    }

    public long number(int length) {
        int from = 1;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int code = this.numberIncl(from, 9);
            if (1 == from) {
                from = 0;
            }
            sb.append((char)(code + 48));
        }
        return Long.valueOf(sb.toString());
    }

    public long number(int min, int max) {
        return this.number(this.numberIncl(min, max));
    }

    public String phone() {
        return "" + this.number(3, 4) + " " + this.number(3, 4) + " " + this.number(3, 4);
    }

    public Calendar date(int year, int month) {
        int day = this.numberIncl(1, 28);
        return new GregorianCalendar(year, month, day);
    }

    public Calendar date(int year) {
        int month = this.numberIncl(0, 11);
        return this.date(year, month);
    }

    public Calendar date() {
        int currentYear = GregorianCalendar.getInstance().get(1);
        int year = this.numberIncl(1950, currentYear);
        return this.date(year);
    }

    public Calendar time() {
        String text = "" + this.numberIncl(0, 23) + ":" + this.numberIncl(0, 59);
        SimpleDateFormat formatter = new SimpleDateFormat("H:mm");
        ParsePosition pos = new ParsePosition(0);
        Date timeValue = formatter.parse(text, pos);
        Calendar cal = GregorianCalendar.getInstance();
        cal.setTime(timeValue);
        return cal;
    }

    public int englishLetterCode() {
        double r = Math.random();
        for (int i = 0; i < LETTER_FREQS.length; ++i) {
            if (!(r < LETTER_FREQS[i])) continue;
            return i;
        }
        return LETTER_FREQS.length;
    }

    public String word(int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            char ch = (char)(this.englishLetterCode() + 97);
            if (0 == i) {
                ch = Character.toUpperCase(ch);
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public String word(int min, int max) {
        return this.word(this.numberIncl(min, max));
    }

    public String sentence(int min, int max) {
        StringBuilder sb = new StringBuilder();
        int wordLengthMin = 3;
        int wordLengthMax = 8;
        int len = this.numberIncl(min, max);
        while (sb.length() < len) {
            String word = this.word(wordLengthMin, wordLengthMax);
            if (0 != sb.length()) {
                word = word.toLowerCase();
            }
            sb.append(word);
            sb.append(' ');
        }
        if (sb.length() > max) {
            sb.setLength(max);
        }
        return sb.toString();
    }
}

