/*
 * Decompiled with CFR 0.152.
 */
package net.sf.seaf.factory.impl;

import java.util.Iterator;
import java.util.Map;
import net.sf.seaf.exception.SeafRuntimeException;
import net.sf.seaf.exception.SeafTypeResolvingException;
import net.sf.seaf.factory.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ListableBeanFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringFactory
implements Factory {
    private final ListableBeanFactory springFactory;
    private final Logger log = LoggerFactory.getLogger(SpringFactory.class);

    public SpringFactory(ListableBeanFactory springFactory) {
        this.springFactory = springFactory;
    }

    @Override
    public <Type> Type getInstanceOf(Class<Type> type) throws SeafRuntimeException {
        Iterator<Type> iterator = this.getBeansOfType(type).values().iterator();
        if (!iterator.hasNext()) {
            throw new SeafTypeResolvingException("No bean of the type defined: " + type);
        }
        Type result = iterator.next();
        if (iterator.hasNext()) {
            throw new SeafTypeResolvingException("Multiple beans of the type defined: " + type);
        }
        this.log.trace("Retrieved bean from Spring context {}", result);
        return result;
    }

    private <Type> Map<String, Type> getBeansOfType(Class<Type> type) {
        return this.springFactory.getBeansOfType(type);
    }
}

