/*
 * Decompiled with CFR 0.152.
 */
package net.sf.seaf.factory.impl;

import java.lang.reflect.Method;
import net.sf.seaf.exception.SeafInitializationException;
import net.sf.seaf.factory.Factory;
import net.sf.seaf.factory.Initializer;
import net.sf.seaf.factory.impl.support.DelegatingFactoryBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetterInitializer
extends DelegatingFactoryBase
implements Initializer<Object> {
    private final Logger log = LoggerFactory.getLogger(SetterInitializer.class);

    public SetterInitializer() {
    }

    public SetterInitializer(Factory instantiatingFactory) {
        super(instantiatingFactory);
    }

    @Override
    public void initialize(Object instance) {
        this.log.trace("Initializing instance {}" + instance);
        Method[] methods = instance.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!this.isSetter(method)) continue;
            this.processSetter(instance, method);
        }
    }

    private void processSetter(Object instance, Method method) {
        Class<?> type = method.getParameterTypes()[0];
        String propertyName = this.getPropertyName(method);
        this.log.trace("Retrieving value for property {} of type {} from the instantiating factory", (Object)propertyName, type);
        Object value = this.getInstantiatingFactory().getInstanceOf(type);
        this.log.trace("Initializing property {} with value {}", (Object)propertyName, value);
        try {
            method.invoke(instance, value);
        }
        catch (Exception e) {
            String message = "Cannot initialize property " + propertyName + " on instance of type " + instance.getClass() + " with value " + value;
            this.log.error(message, (Throwable)e);
            throw new SeafInitializationException(message, e);
        }
    }

    private boolean isSetter(Method method) {
        return method.getName().startsWith("set") && 1 == method.getParameterTypes().length;
    }

    private String getPropertyName(Method method) {
        String propertyName = method.getName().substring(3);
        if (propertyName.length() > 0) {
            propertyName = propertyName.substring(0, 1).toLowerCase() + propertyName.substring(1);
            return propertyName;
        }
        return "<empty name>";
    }
}

