/*
 * Decompiled with CFR 0.152.
 */
package net.sf.seaf.factory.impl;

import net.sf.seaf.exception.SeafInitializationException;
import net.sf.seaf.exception.SeafRuntimeException;
import net.sf.seaf.factory.Factory;
import net.sf.seaf.factory.Initializer;
import net.sf.seaf.factory.impl.support.DelegatingFactoryBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitializingFactory
extends DelegatingFactoryBase
implements Factory {
    private Initializer<?> initializer;
    private final Logger log = LoggerFactory.getLogger(InitializingFactory.class);

    public InitializingFactory() {
    }

    public InitializingFactory(Initializer<?> initializer, Factory instantiatingFactory) {
        super(instantiatingFactory);
        this.initializer = initializer;
    }

    @Override
    public <Type> Type getInstanceOf(Class<Type> type) throws SeafRuntimeException {
        Type instance = this.getInstantiatingFactory().getInstanceOf(type);
        this.log.trace("Initializing instance of type {}", type);
        try {
            this.getInitializer(type).initialize(instance);
        }
        catch (ClassCastException e) {
            String message = "Cannot initialize instance of type " + type + " in initializer " + this.initializer.getClass().getName();
            this.log.error(message, (Throwable)e);
            throw new SeafInitializationException(message, e);
        }
        this.log.trace("Initialized instance {}", instance);
        return instance;
    }

    private <Type> Initializer<Type> getInitializer(Class<Type> type) {
        return this.initializer;
    }

    public final void setInitializer(Initializer<?> initializer) {
        this.initializer = initializer;
    }
}

