/*
 * Decompiled with CFR 0.152.
 */
package net.sf.seaf.factory.impl;

import java.util.HashMap;
import java.util.Map;
import net.sf.seaf.factory.Factory;
import net.sf.seaf.factory.impl.support.DelegatingFactoryBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingFactory
extends DelegatingFactoryBase
implements Factory {
    private final Map<Class<?>, Object> cache = new HashMap();
    private final Logger log = LoggerFactory.getLogger(CachingFactory.class);

    public CachingFactory() {
    }

    public CachingFactory(Factory instantiatingFactory) {
        super(instantiatingFactory);
    }

    @Override
    public final synchronized <Type> Type getInstanceOf(Class<Type> type) {
        if (this.getCache().containsKey(type)) {
            Object cachedInstance = this.getCache().get(type);
            this.log.trace("Returning cached instance {}", cachedInstance);
            return (Type)cachedInstance;
        }
        this.log.trace("Delegating instantiation of type {} to instantiating factory", type);
        Type newInstance = this.getInstantiatingFactory().getInstanceOf(type);
        this.getCache().put(type, newInstance);
        this.log.trace("Returning newly created instance {}", newInstance);
        return newInstance;
    }

    private Map<Class<?>, Object> getCache() {
        return this.cache;
    }
}

