package net.sf.seaf.util.convert.simple;

import java.util.Calendar;

import net.sf.seaf.util.TemporalConverterUtil;

/**
 * Converter of any Object to a timestamp represented by Calendar.
 */
public class ConverterToTimestamp {

	public static final String FORMAT_ISO = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";

	/**
	 * Converts an Object to Calendar timestamp value.
	 * <p>
	 * Keeps null as null. Converts java.util.Date. Keeps Calendar. Otherwise
	 * converts via String expecting ISO timestamp format
	 * (yyyy-MM-dd'T'HH:mm:ss.SSSZ).
	 * 
	 * @param o
	 *            Object to be converted
	 * @return Calendar
	 * @throws IllegalArgumentException
	 *             Thrown when the argument is not a valid Timestamp
	 */
	public static Calendar convert(Object o) throws IllegalArgumentException {
		return TemporalConverterUtil.convert(o, FORMAT_ISO);
	}

}
