package net.sf.seaf.util.convert.simple;

import java.util.Calendar;

import net.sf.seaf.util.TemporalConverterUtil;

/**
 * Converter of any Object to a time represented by Calendar.
 */
public class ConverterToTime {

	public static final String FORMAT_ISO = "HH:mm:ss";

	/**
	 * Converts an Object to Calendar time value.
	 * <p>
	 * Keeps null as null. Converts java.util.Date. Keeps Calendar.
	 * <p>
	 * Otherwise converts via String expecting ISO time format (HH:MM:SS). The
	 * day is set to 1.1.1970.
	 * 
	 * @param o
	 *            Object to be converted
	 * @return Calendar
	 * @throws IllegalArgumentException
	 *             Thrown when the argument is not a valid Time
	 */
	public static Calendar convert(Object o) throws IllegalArgumentException {
		return TemporalConverterUtil.convert(o, FORMAT_ISO);
	}

}
