package net.sf.seaf.util.convert.simple;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

import net.sf.seaf.util.TemporalConverterUtil;

/**
 * Converter of any Object to String.
 */
public class ConverterToString {

	/**
	 * Converts an Object to String value, keeping null as null.
	 * 
	 * @param o
	 *            Object to be converted
	 * @return String The String value of the object
	 */
	public static String convert(Object o) {
		return (null == o) ? null : String.valueOf(o);
	}

	/**
	 * Converts an Object of a temporal type to String value.
	 * <p>
	 * Keeps null as null.
	 * 
	 * @param o
	 *            Object to be converted
	 * @param type
	 *            The type of the object
	 * @return String The String value of the object
	 */
	public static String convert(Object o, TemporalType type) {
		if (null == o)
			return null;

		String format = getFormatByType(type);
		Calendar cal;
		if (o instanceof Date) {
			cal = new GregorianCalendar();
			cal.setTime((Date) o);
		} else if (o instanceof Calendar)
			cal = (Calendar) o;
		else
			return convert(o);
		return TemporalConverterUtil.formatDate(cal, format);
	}

	private static String getFormatByType(TemporalType type) {
		if (TemporalType.DATE.equals(type))
			return ConverterToDate.FORMAT_ISO;
		else if (TemporalType.DATETIME.equals(type))
			return ConverterToDatetime.FORMAT_ISO;
		else if (TemporalType.TIME.equals(type))
			return ConverterToTime.FORMAT_ISO;
		return ConverterToTimestamp.FORMAT_ISO;
	}

}
