package net.sf.seaf.util.convert.simple;

/**
 * Converter of any Object to Long.
 */
public class ConverterToLong {

	/**
	 * Converts an Object to Long value.
	 * <p>
	 * Keeps null as null. Floating point number is cut to its longValue().
	 * Boolean is converted to 1 or 0. Throws NumberFormatException if cannot be
	 * parsed.
	 * 
	 * @param o
	 *            Object to be converted
	 * @return Long
	 * @throws NumberFormatException
	 *             Thrown when the argument cannot be converted to Long
	 */
	public static Long convert(Object o) throws NumberFormatException {
		if (null == o)
			return null;
		if (o instanceof Double)
			return ((Double) o).longValue();
		if (o instanceof Float)
			return ((Float) o).longValue();
		if (o instanceof Boolean)
			return ((Boolean) o) ? 1L : 0L;
		return Long.valueOf(String.valueOf(o));
	}

}
