package net.sf.seaf.util.convert.simple;

/**
 * Converter of any Object to Integer.
 */
public class ConverterToInteger {

	/**
	 * Converts an Object to Integer value.
	 * <p>
	 * Keeps null as null. Floating point number is cut to its intValue().
	 * Boolean is converted to 1 or 0. Throws NumberFormatException if cannot be
	 * parsed.
	 * 
	 * @param o
	 *            Object to be converted
	 * @return Integer
	 * @throws NumberFormatException
	 *             Thrown when the argument cannot be converted to Integer
	 */
	public static Integer convert(Object o) throws NumberFormatException {
		if (null == o)
			return null;
		return ConverterToLong.convert(o).intValue();
	}
}
