package net.sf.seaf.util.convert.simple;

import java.util.Calendar;

import net.sf.seaf.util.TemporalConverterUtil;

/**
 * Converter of any Object to a date-time represented by Calendar.
 */
public class ConverterToDatetime {

	public static final String FORMAT_ISO = "yyyy-MM-dd'T'HH:mm:ss";

	/**
	 * Converts an Object to Calendar date-time value.
	 * <p>
	 * Keeps null as null. Converts java.util.Date. Keeps Calendar. Otherwise
	 * converts via String expecting ISO date-time format
	 * (YYYY-MM-DD'T'HH:MM:SS).
	 * 
	 * @param o
	 *            Object to be converted
	 * @return Calendar
	 * @throws IllegalArgumentException
	 *             Thrown when the argument is not a valid Datetime
	 */
	public static Calendar convert(Object o) throws IllegalArgumentException {
		return TemporalConverterUtil.convert(o, FORMAT_ISO);
	}

}
