package net.sf.seaf.util.convert.simple;

import java.util.Calendar;

import net.sf.seaf.util.TemporalConverterUtil;

/**
 * Converter of any Object to a date represented by Calendar.
 */
public class ConverterToDate {

	public static final String FORMAT_ISO = "yyyy-MM-dd";

	/**
	 * Converts an Object to Calendar date value.
	 * <p>
	 * Keeps null as null. Converts java.util.Date. Keeps Calendar. Otherwise
	 * converts via String expecting ISO date format (YYYY-MM-DD.).
	 * 
	 * @param o
	 *            Object to be converted
	 * @return Calendar
	 * @throws IllegalArgumentException
	 *             Thrown when the argument is not a valid Date
	 */
	public static Calendar convert(Object o) throws IllegalArgumentException {
		return TemporalConverterUtil.convert(o, FORMAT_ISO);
	}

}
