package net.sf.seaf.util.convert.simple;

/**
 * Converter of any Object to Boolean.
 */
public class ConverterToBoolean {

	/**
	 * Converts an Object to Boolean value.
	 * <p>
	 * Keeps null as null. Converts 0, false and no to boolean false. Converts
	 * 1, true and yes to boolean true.
	 * 
	 * @param o
	 *            Object to be converted
	 * @return Boolean
	 * @throws IllegalArgumentException
	 *             Thrown when the argument cannot be converted to Boolean
	 */
	public static Boolean convert(Object o) throws IllegalArgumentException {
		if (null == o)
			return null;

		String s = String.valueOf(o).trim().toLowerCase();
		if ("1".equals(s) || "true".equals(s) || "yes".equals(s))
			return true;
		if ("0".equals(s) || "false".equals(s) || "no".equals(s))
			return false;

		throw new IllegalArgumentException("Not a boolean value: " + s);
	}

}
