package net.sf.seaf.util.convert.collection;

/**
 * Converts an Object from Source type to Target type.
 * 
 * @param &lt;Source>
 * @param &lt;Target>
 */
public interface ObjectConverter<Source, Target> {

	/**
	 * Converts an Object from Source type to Target type.
	 * 
	 * @param source
	 *            The Source object
	 * @return Target The Target object
	 */
	public Target convert(Source source);

}
