package net.sf.seaf.util.convert.collection;

import java.util.Collection;

/**
 * Converts a Collection of objects of type Source to a Collection of objects of
 * type Target.
 * 
 * @param &lt;Source>
 * @param &lt;Target>
 */
public class CollectionConverter<Source, Target> {

	/**
	 * Converts a Collection of objects of type Source to a Collection of
	 * objects of type Target. Each Source object is converted to an object of
	 * type Target using the supplied ObjectConvertor. The supplied Target
	 * Collection is cleared first.
	 * 
	 * @param sourceCollection
	 *            The collection of the Source objects
	 * @param targetCollection
	 *            The collection of the Target objects
	 * @param objectConverter
	 *            An ObjectConvertor to convert each Source to a Target
	 * @return Collection&lt;Target> A collection of Target objects
	 */
	public Collection<Target> convert(Collection<Source> sourceCollection,
			Collection<Target> targetCollection,
			ObjectConverter<Source, Target> objectConverter) {
		targetCollection.clear();
		for (Source source : sourceCollection)
			targetCollection.add(objectConverter.convert(source));
		return targetCollection;
	}

}
