package net.sf.seaf.util.bean;

import org.apache.commons.beanutils.PropertyUtils;

/**
 * Extracts the values of bean properties by property name.
 */
public class PropertyValueExtractor {

	final private Object bean;

	/**
	 * Creates a extractor for a given bean.
	 * 
	 * @param bean
	 *            The bean on which property values are to be extracted
	 */
	public PropertyValueExtractor(Object bean) {
		this.bean = bean;
	}

	/**
	 * Extracts the value of the given property.
	 * 
	 * @param propertyName
	 *            The name of the property to extract
	 * @return Object The value of the property extracted
	 * @throws IllegalArgumentException
	 *             Thrown when the property value cannot be accessed
	 */
	public Object extractPropertyValue(String propertyName)
			throws IllegalArgumentException {
		try {
			return PropertyUtils.getProperty(bean, propertyName);
		} catch (Exception e) {
			throw new IllegalArgumentException("Cannot access property name: "
					+ propertyName + " of bean: " + bean.getClass().getName(),
					e);
		}
	}

}
