package net.sf.seaf.factory.impl;

import net.sf.seaf.factory.Factory;
import net.sf.seaf.factory.Proxy;
import net.sf.seaf.factory.impl.support.DelegatingFactoryBase;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Factory that proxies the returned instances with a {@link Proxy}.
 */
public class ProxyingFactory extends DelegatingFactoryBase implements Factory {

	private Proxy proxy;
	private final Logger log = LoggerFactory.getLogger(ProxyingFactory.class);

	/**
	 * Default empty constructor. The proxy and instantiating factory must be
	 * supplied via its setter methods.
	 */
	public ProxyingFactory() {
	}

	/**
	 * Full constructor.
	 * 
	 * @param proxy
	 *            The proxy
	 * @param instantiatingFactory
	 *            The instantiating factory
	 */
	public ProxyingFactory(Proxy proxy, Factory instantiatingFactory) {
		super(instantiatingFactory);
		this.proxy = proxy;
	}

	public <Type> Type getInstanceOf(Class<Type> type) {
		Type instance = getInstantiatingFactory().getInstanceOf(type);
		getProxy().setProxiedObject(instance);
		Class<? extends Object> instanceClass = instance.getClass();
		@SuppressWarnings("unchecked")
		Type proxyInstance = (Type) java.lang.reflect.Proxy.newProxyInstance(
				instanceClass.getClassLoader(), instanceClass.getInterfaces(),
				getProxy());
		log.trace("Proxied instance of type {} by a dynamic proxy", type);
		return proxyInstance;
	}

	private Proxy getProxy() {
		return proxy;
	}

	/**
	 * Set the proxy.
	 * 
	 * @param proxy
	 *            The proxy
	 */
	public final void setProxy(Proxy proxy) {
		this.proxy = proxy;
	}

}
