package net.sf.seaf.factory;

/**
 * Resolves subtypes of a given type.
 * 
 * @param <Type>
 *            The type subtypes of which can be resolved
 */
public interface TypeResolver<Type> {

	/**
	 * Resolve a type.
	 * 
	 * @param type
	 *            The type to resolve
	 * @return The resolved type
	 */
	Class<? extends Type> resolve(Class<Type> type);

}
