package net.sf.seaf.factory;

import net.sf.seaf.exception.SeafRuntimeException;

/**
 * Factory instantiates and initializes objects.
 * <p>
 * It is assumed that for a given type, all instances are created and
 * initialized in the same way.
 */
public interface Factory {

	/**
	 * Return an initialized instance of the specified type.
	 * 
	 * @param type
	 *            The type of the requested instance
	 * @return The instance
	 * @throws SeafRuntimeException
	 *             Thrown when the instance cannot be retrieved
	 */
	<Type> Type getInstanceOf(Class<Type> type) throws SeafRuntimeException;

}
