/**
 * GENERATED BY JavaBeans Generator. DO NOT EDIT.
 */
package net.sf.seaf.common;

import java.io.Serializable;
import java.util.Arrays;

import net.sf.seaf.util.HashCodeUtils;
import net.sf.seaf.util.ToStringUtils;

/**
 * Specification of the sort on a property.
 * 
 * @param <P>
 *            Property enum
 */
public class PropertySort<P extends Enum<?>> implements Serializable {

	/**
	 * Name of the property to sort on.
	 */
	private P property;

	/**
	 * Order in which to sort.
	 */
	private SortOrder order;

	/**
	 * Default constructor of JavaBean PropertySort.
	 * 
	 */
	public PropertySort() {
	}

	/**
	 * Construct property sort for the given property. The sort order is
	 * ascending.
	 * 
	 * @param property
	 *            The property to sort on
	 */
	public PropertySort(P property) {
		this(property, SortOrder.asc);
	}

	/**
	 * Full constructor of JavaBean PropertySort.
	 * 
	 * @param property
	 *            The property to sort on
	 * @param order
	 *            Order of the sort
	 */
	public PropertySort(P property, SortOrder order) {
		setProperty(property);
		setOrder(order);
	}

	/**
	 * Default getter for property property.
	 * 
	 * @return The property property
	 */
	public final P getProperty() {
		return property;
	}

	/**
	 * Default setter for property property.
	 * 
	 * @param property
	 *            New value for the property property
	 */
	public void setProperty(P property) {
		this.property = property;
	}

	/**
	 * Default getter for property order.
	 * 
	 * @return The order property
	 */
	public final SortOrder getOrder() {
		return order;
	}

	/**
	 * Default setter for property order.
	 * 
	 * @param order
	 *            New value for the order property
	 */
	public final void setOrder(SortOrder order) {
		this.order = order;
	}

	// Java standard methods implementation

	/**
	 * Return the values of the business key properties of the bean.
	 * 
	 * @return Object[]
	 */
	private Object[] businessKeyValues() {
		return new Object[] { getProperty(), getOrder() };
	}

	@Override
	public int hashCode() {
		int superHashCode = 0;
		if (!PropertySort.class.getSuperclass().equals(Object.class))
			superHashCode = super.hashCode();
		return HashCodeUtils.hashCodeFor(superHashCode, businessKeyValues());
	}

	@Override
	public boolean equals(Object object) {
		if (this == object)
			return true;
		if (null == object)
			return false;
		if (!(getClass().equals(object.getClass())))
			return false;
		if (!PropertySort.class.getSuperclass().equals(Object.class)
				&& !super.equals(object))
			return false;
		final PropertySort<?> that = (PropertySort<?>) object;
		return Arrays
				.equals(this.businessKeyValues(), that.businessKeyValues());
	}

	@Override
	public String toString() {
		ToStringUtils u = new ToStringUtils(PropertySort.class,
				super.toString());
		u.addProperty("property", getProperty());
		u.addProperty("order", getOrder());
		return u.toString();
	}

	private static final long serialVersionUID = 1L;
}
