/*
 * Decompiled with CFR 0.152.
 */
package net.sf.seaf.util.bean;

import java.beans.PropertyDescriptor;
import net.sf.seaf.util.bean.PropertyValueExtractor;
import net.sf.seaf.util.bean.PropertyVisitor;
import org.apache.commons.beanutils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyEnumerator {
    Logger log = LoggerFactory.getLogger(PropertyEnumerator.class);

    public void enumerate(Object bean, PropertyVisitor visitor) {
        PropertyDescriptor[] propertyDescriptors;
        this.log.debug("Enumerating properties of bean {}", bean);
        PropertyValueExtractor pve = new PropertyValueExtractor(bean);
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors = PropertyUtils.getPropertyDescriptors((Object)bean)) {
            Object value;
            String name = propertyDescriptor.getName();
            Class<?> type = propertyDescriptor.getPropertyType();
            try {
                value = pve.extractPropertyValue(name);
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            this.log.trace("Visiting property {} of type {} with value {}", new Object[]{name, type, value});
            visitor.visit(bean, name, type, value);
        }
    }
}

