/*
 * Decompiled with CFR 0.152.
 */
package net.sf.seaf.factory.impl;

import net.sf.seaf.exception.SeafTypeResolvingException;
import net.sf.seaf.factory.Factory;
import net.sf.seaf.factory.TypeResolver;
import net.sf.seaf.factory.impl.support.DelegatingFactoryBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeResolvingFactory
extends DelegatingFactoryBase
implements Factory {
    private TypeResolver<?> typeResolver;
    private final Logger log = LoggerFactory.getLogger(TypeResolvingFactory.class);

    public TypeResolvingFactory() {
    }

    public TypeResolvingFactory(TypeResolver<?> typeResolver, Factory instantiatingFactory) {
        super(instantiatingFactory);
        this.typeResolver = typeResolver;
    }

    @Override
    public <Type> Type getInstanceOf(Class<Type> type) throws SeafTypeResolvingException {
        Class<Type> resolvedType = this.getTypeResolver(type).resolve(type);
        this.log.trace("Resolved type {} as {}", type, resolvedType);
        if (null == resolvedType) {
            String message = "Cannot resolve type " + type + " in type resolver " + this.typeResolver.getClass().getName() + ", resolver returned null";
            this.log.error(message);
            throw new SeafTypeResolvingException(message);
        }
        return this.getInstantiatingFactory().getInstanceOf(resolvedType);
    }

    private <Type> TypeResolver<Type> getTypeResolver(Class<Type> type) {
        return this.typeResolver;
    }

    public final void setTypeResolver(TypeResolver<?> typeResolver) {
        this.typeResolver = typeResolver;
    }
}

