/*
 * Decompiled with CFR 0.152.
 */
package net.sf.seaf.factory.impl;

import net.sf.seaf.exception.SeafInstantiationException;
import net.sf.seaf.factory.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultInstantiatingFactory
implements Factory {
    private final Logger log = LoggerFactory.getLogger(DefaultInstantiatingFactory.class);

    @Override
    public final <Type> Type getInstanceOf(Class<Type> type) throws SeafInstantiationException {
        this.log.trace("Instantiating type {}", type);
        try {
            return type.newInstance();
        }
        catch (InstantiationException e) {
            throw this.processException(type, e);
        }
        catch (IllegalAccessException e) {
            throw this.processException(type, e);
        }
    }

    private <Type> SeafInstantiationException processException(Class<Type> type, Exception e) {
        String msg = "Cannot instantiate " + type + ", does it have a public default constuctor?";
        this.log.error(msg, (Throwable)e);
        return new SeafInstantiationException(msg, e);
    }
}

