package net.sf.seaf.util.convert.simple;

/**
 * Converter of any Object to Float.
 */
public class ConverterToFloat {

	/**
	 * Converts an Object to Float value.
	 * <p>
	 * Keeps null as null. Boolean is converted to 1 or 0. Throws
	 * NumberFormatException if cannot be parsed.
	 * 
	 * @param o
	 *            Object to be converted
	 * @return Float
	 * @throws NumberFormatException
	 *             Thrown when the argument cannot be converted to Float
	 */
	public static Float convert(Object o) throws NumberFormatException {
		if (null == o)
			return null;
		return ConverterToDouble.convert(o).floatValue();
	}

}
