package net.sf.seaf.util.convert.simple;

/**
 * Converter of any Object to Enum.
 */
public class ConverterToEnum {

	/**
	 * Converts an Object to enum value.
	 * <p>
	 * Keeps null as null. Keeps enum value as passed in. Otherwise converts via
	 * String to an enum value of the given enum class.
	 * 
	 * @param o
	 *            Object to be converted
	 * @param enumClass
	 *            Target enum class
	 * @return Enum value
	 * @throws IllegalArgumentException
	 *             Thrown when the object cannot be converted to an instance of
	 *             the enumeration provided
	 */
	public static <E extends Enum<E>> E convert(Object o, Class<E> enumClass)
			throws IllegalArgumentException {
		if (null == o)
			return null;
		if (o instanceof Enum) {
			@SuppressWarnings("unchecked")
			E e = (E) o;
			return e;
		}
		String s = String.valueOf(o).trim();
		return Enum.valueOf(enumClass, s);
	}

}
