package net.sf.seaf.util.convert.simple;

/**
 * Converter of any Object to Double.
 */
public class ConverterToDouble {

	/**
	 * Converts an Object to Double value.
	 * <p>
	 * Keeps null as null. Boolean is converted to 1 or 0. Throws
	 * NumberFormatException if cannot be parsed.
	 * 
	 * @param o
	 *            Object to be converted
	 * @return Double
	 * @throws NumberFormatException
	 *             Thrown when the argument cannot be converted to Double
	 */
	public static Double convert(Object o) throws NumberFormatException {
		if (null == o)
			return null;
		if (o instanceof Boolean)
			return ((Boolean) o) ? 1.0 : 0.0;
		return Double.valueOf(String.valueOf(o));
	}

}
