package net.sf.seaf.util.bean;

/**
 * Property visitor interface.
 */
public interface PropertyVisitor {

	/**
	 * Visit a bean property.
	 * 
	 * @param bean
	 *            The bean instance
	 * @param name
	 *            The name of the property
	 * @param type
	 *            The type of the property
	 * @param value
	 *            The value of the property
	 */
	void visit(Object bean, String name, Class<?> type, Object value);

}
