package net.sf.seaf.util.bean;

import java.beans.PropertyDescriptor;

import org.apache.commons.beanutils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyEnumerator {

	Logger log = LoggerFactory.getLogger(PropertyEnumerator.class);

	/**
	 * Enumerate all properties of a bean, visiting each one using a
	 * {@link PropertyVisitor}.
	 * 
	 * @param bean
	 *            The bean
	 * @param visitor
	 *            The property visitor
	 */
	public void enumerate(Object bean, PropertyVisitor visitor) {
		log.debug("Enumerating properties of bean {}", bean);
		PropertyValueExtractor pve = new PropertyValueExtractor(bean);
		PropertyDescriptor[] propertyDescriptors = PropertyUtils
				.getPropertyDescriptors(bean);
		for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
			String name = propertyDescriptor.getName();
			Class<?> type = propertyDescriptor.getPropertyType();
			Object value;
			try {
				value = pve.extractPropertyValue(name);
			} catch (IllegalArgumentException e) {
				continue;
			}
			log.trace("Visiting property {} of type {} with value {}",
					new Object[] { name, type, value });
			visitor.visit(bean, name, type, value);
		}
	}

}
